/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestProvider;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryIdentifier;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerWebhookEventIndex;
import com.teamscale.index.repository.git.bitbucket.server.client.BitbucketServerClient;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequest;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import java.time.Duration;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.concurrent.ThreadUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class BitbucketServerMergeRequestUpdateTrigger
extends MergeRequestUpdateTriggerBase<BitbucketServerMergeRequestProvider, BitbucketServerPullRequest, CommitStatus> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    protected BitbucketServerMergeRequestProvider createMergeRequestProvider(GlobalStorageSystem globalStorageSystem, ProjectStorageSystem projectStorageSystem, String repositoryName) throws StorageException {
        ExternalCredentials credentials = this.extractCredentials(globalStorageSystem, projectStorageSystem, repositoryName, ERepositoryConnector.BITBUCKET_SERVER);
        BitbucketServerClient client = new BitbucketServerClient(credentials.uri, credentials.username, credentials.password, LOGGER);
        ConnectorConfiguration connector = BitbucketServerMergeRequestUpdateTrigger.extractConnectorConfiguration(projectStorageSystem, repositoryName, ERepositoryConnector.BITBUCKET_SERVER);
        return new BitbucketServerMergeRequestProvider(BitbucketServerRepositoryIdentifier.fromRepositoryName(repositoryName), client, VotingConnectorUtils.getBuildIncludeExcludePatterns(connector));
    }

    @Override
    protected void execute(MergeRequestIdentifier identifier, BitbucketServerMergeRequestProvider provider) throws ServiceCallException, StorageException {
        if (identifier.id() != Long.MIN_VALUE) {
            super.execute(identifier, provider);
            return;
        }
        String repositoryName = identifier.repositoryName();
        String sourceBranchRefId = this.getJobExtraParameter();
        if (this.repositoryReceivedSrcBranchUpdatedEvent(repositoryName)) {
            LOGGER.debug("Skipping fetching of all pull requests with source branch '{}', because the 'Source branch updated' event is enabled.", (Object)sourceBranchRefId);
            return;
        }
        LOGGER.warn("Repository {} has not received a 'Source branch updated' webhook event from the Bitbucket Server instance yet. Please update the repository's webhook settings to include the 'Source branch updated' event, if it is not yet included.", (Object)repositoryName);
        try {
            ThreadUtils.sleep((Duration)Duration.ofSeconds(BitbucketServerRepositoryConnectorDescriptor.MERGE_REQUEST_UPDATE_DELAY_SECONDS));
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while waiting for pull requests to be updated.", (Throwable)e);
        }
        List<BitbucketServerPullRequest> pullRequests = this.fetchAllOpenPullRequestsWithSrcBranch(sourceBranchRefId, repositoryName, provider);
        for (BitbucketServerPullRequest pullRequest : pullRequests) {
            MergeRequestIdentifier newIdentifier = new MergeRequestIdentifier(repositoryName, pullRequest.id());
            super.processMergeRequest(newIdentifier, pullRequest, provider);
        }
    }

    @VisibleForTesting
    public List<BitbucketServerPullRequest> fetchAllOpenPullRequestsWithSrcBranch(String sourceBranchRefId, String repositoryName, BitbucketServerMergeRequestProvider provider) throws ServiceCallException {
        List<BitbucketServerPullRequest> pullRequests = provider.getClient().getOpenPullRequestsForSourceBranch(BitbucketServerRepositoryIdentifier.fromRepositoryName(repositoryName), sourceBranchRefId);
        LOGGER.debug("Fetched all pull requests with source branch '{}': {}", new Supplier[]{() -> sourceBranchRefId, () -> JsonUtils.serializeToJSON((Object)pullRequests)});
        return pullRequests;
    }

    @VisibleForTesting
    public boolean repositoryReceivedSrcBranchUpdatedEvent(String repositoryName) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.jobDescriptor.getInternalProjectId());
        BitbucketServerWebhookEventIndex bitbucketServerWebhookEventIndex = (BitbucketServerWebhookEventIndex)projectStorageSystem.openProjectIndex(BitbucketServerWebhookEventIndex.class, null);
        return bitbucketServerWebhookEventIndex.containsWebhookEvent(repositoryName, "pr:from_ref_updated");
    }

    @Override
    protected ExternalCredentials extractCredentials(GlobalStorageSystem globalStorageSystem, ProjectStorageSystem projectStorageSystem, String repositoryName, ERepositoryConnector connector) throws StorageException {
        repositoryName = MergeRequestIndex.sanitizeRepositoryName(repositoryName);
        return super.extractCredentials(globalStorageSystem, projectStorageSystem, repositoryName, connector);
    }

    @Override
    protected MergeRequestAnnotationTriggerBase<BitbucketServerPullRequest, CommitStatus> createMergeRequestAnnotationTrigger() {
        return new BitbucketServerMergeRequestAnnotationTrigger();
    }
}

