/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerDiffHunk;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerDiffLine;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerDiffSegment;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerDiffSide;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

public class BitbucketServerPullRequestDiff {
    @JsonProperty(value="source")
    private BitbucketServerDiffSide source;
    @JsonProperty(value="destination")
    private BitbucketServerDiffSide destination;
    @JsonProperty(value="hunks")
    private BitbucketServerDiffHunk[] hunks;

    public String getDestinationPath() {
        if (this.destination == null) {
            return null;
        }
        return this.destination.getPath();
    }

    public List<BitbucketServerDiffHunk> getHunks() {
        if (this.hunks == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.hunks);
    }

    public PairList<Integer, Integer> getDestinationRangesFromHunks() {
        PairList ranges = new PairList();
        this.getHunks().forEach(hunk -> ranges.add((Object)hunk.destinationLine(), (Object)hunk.getDestinationEndLine()));
        return ranges;
    }

    public PairList<Integer, Integer> getDestinationRangesForChangedLinesOnlyFromHunks() {
        PairList ranges = new PairList();
        for (BitbucketServerDiffHunk hunk : this.getHunks()) {
            List changedLinesSegments = CollectionUtils.filter(hunk.getSegments(), diffSegment -> "ADDED".equals(diffSegment.type()));
            for (BitbucketServerDiffSegment segment : changedLinesSegments) {
                int segmentLines = segment.lines().length;
                ranges.add((Object)segment.lines()[0].destination(), (Object)segment.lines()[segmentLines - 1].destination());
            }
        }
        return ranges;
    }

    public List<BitbucketServerDiffLine> getAllDiffLines() {
        ArrayList<BitbucketServerDiffLine> diffLines = new ArrayList<BitbucketServerDiffLine>();
        for (BitbucketServerDiffHunk hunk : this.getHunks()) {
            for (BitbucketServerDiffSegment segment : hunk.getSegments()) {
                diffLines.addAll(segment.getDiffLines());
            }
        }
        return diffLines;
    }
}

