/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.dump;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GitConnectorConfigurationDump {
    private static final String DEFAULT_BRANCH_NAME = "defaultBranchName";
    private static final String BRANCH_INCLUDE_PATTERNS = "branchIncludePatterns";
    private static final String BRANCH_EXCLUDE_PATTERNS = "branchExcludePatterns";
    private static final String IMPORTANT_BRANCH_PATTERNS = "importantBranchPatterns";
    private static final String START_REVISION_OR_DATE = "startRevisionOrDate";
    private static final String END_REVISION_OR_DATE = "endRevisionOrDate";
    private static final String BRANCHING_ENABLED = "branchingEnabled";
    private static final String KEEP_RESURRECTED_BRANCH_HISTORY = "keepResurrectedBranchHistory";
    @JsonProperty(value="defaultBranchName")
    public final String defaultBranchName;
    @JsonProperty(value="branchIncludePatterns")
    public final List<Pattern> branchIncludePatterns;
    @JsonProperty(value="branchExcludePatterns")
    public final List<Pattern> branchExcludePatterns;
    @JsonProperty(value="importantBranchPatterns")
    public final List<Pattern> importantBranchPatterns;
    @JsonProperty(value="startRevisionOrDate")
    public final String startRevisionOrDate;
    @JsonProperty(value="endRevisionOrDate")
    public final String endRevisionOrDate;
    @JsonProperty(value="branchingEnabled")
    public final boolean branchingEnabled;
    @JsonProperty(value="keepResurrectedBranchHistory")
    public final boolean keepResurrectedBranchHistory;

    public GitConnectorConfigurationDump(String defaultBranchName, IncludeExcludeRegexSupport branchPatternSupport, PatternList importantBranchPatterns, String startRevisionOrDate, String endRevisionOrDate, boolean branchingEnabled, boolean keepResurrectedBranchHistory) {
        this.defaultBranchName = defaultBranchName;
        this.branchIncludePatterns = branchPatternSupport.getCompiledIncludePatterns();
        this.branchExcludePatterns = branchPatternSupport.getCompiledExcludePatterns();
        this.importantBranchPatterns = importantBranchPatterns;
        this.startRevisionOrDate = startRevisionOrDate;
        this.endRevisionOrDate = endRevisionOrDate;
        this.branchingEnabled = branchingEnabled;
        this.keepResurrectedBranchHistory = keepResurrectedBranchHistory;
    }

    @JsonCreator
    public GitConnectorConfigurationDump(@JsonProperty(value="defaultBranchName") String defaultBranchName, @JsonProperty(value="branchIncludePatterns") List<Pattern> branchIncludePatterns, @JsonProperty(value="branchExcludePatterns") List<Pattern> branchExcludePatterns, @JsonProperty(value="importantBranchPatterns") List<Pattern> importantBranchPatterns, @JsonProperty(value="startRevisionOrDate") String startRevisionOrDate, @JsonProperty(value="endRevisionOrDate") String endRevisionOrDate, @JsonProperty(value="branchingEnabled") boolean branchingEnabled, @JsonProperty(value="keepResurrectedBranchHistory") boolean keepResurrectedBranchHistory) {
        this.defaultBranchName = defaultBranchName;
        this.branchIncludePatterns = branchIncludePatterns;
        this.branchExcludePatterns = branchExcludePatterns;
        this.importantBranchPatterns = importantBranchPatterns;
        this.startRevisionOrDate = startRevisionOrDate;
        this.endRevisionOrDate = endRevisionOrDate;
        this.branchingEnabled = branchingEnabled;
        this.keepResurrectedBranchHistory = keepResurrectedBranchHistory;
    }

    public String toGitBranchLabelerCommandLineParameters() {
        return "--default \"" + this.defaultBranchName + "\"" + GitConnectorConfigurationDump.makeParameterList("include", this.branchIncludePatterns.stream().map(Pattern::pattern)) + GitConnectorConfigurationDump.makeParameterList("exclude", this.branchExcludePatterns.stream().map(Pattern::pattern)) + GitConnectorConfigurationDump.makeParameterList("important", this.importantBranchPatterns.stream().map(Pattern::pattern)) + GitConnectorConfigurationDump.makeParameter("start", this.startRevisionOrDate) + GitConnectorConfigurationDump.makeParameter("end", this.endRevisionOrDate) + GitConnectorConfigurationDump.makeParameterUnescaped("branching-enabled", Boolean.toString(this.branchingEnabled)) + GitConnectorConfigurationDump.makeParameterUnescaped("keep-resurrected-branch-history", Boolean.toString(this.keepResurrectedBranchHistory));
    }

    private static @NonNull String makeParameterUnescaped(String parameterName, @Nullable String parameterValue) {
        return GitConnectorConfigurationDump.makeParameterList(parameterName, Stream.of(parameterValue), "");
    }

    private static @NonNull String makeParameter(String parameterName, @Nullable String parameterValue) {
        return GitConnectorConfigurationDump.makeParameterList(parameterName, Stream.of(parameterValue));
    }

    private static @NonNull String makeParameterList(String parameterName, Stream<@Nullable String> parameterValues) {
        return GitConnectorConfigurationDump.makeParameterList(parameterName, parameterValues, "\"");
    }

    private static @NonNull String makeParameterList(String parameterName, Stream<@Nullable String> parameterValues, String escapeString) {
        String parameterList = parameterValues.filter(Objects::nonNull).map(value -> "--" + parameterName + " " + escapeString + value + escapeString).collect(Collectors.joining(" "));
        if (StringUtils.isEmpty((String)parameterList)) {
            return "";
        }
        return " " + parameterList;
    }
}

