/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.dump;

import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.debug.DebugDumperRegistry;
import com.teamscale.core.debug.EDebugDumpEvent;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDebugDumper;
import com.teamscale.index.repository.git.debug_dump.dump.IGitRepositoryDebugDumper;
import com.teamscale.index.repository.git.debug_dump.dump.NoOpGitRepositoryDebugDumper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;

public class GitRepositoryDebugDumperFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IGitRepositoryDebugDumper createDebugDumper(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, GitRepositoryConnectorParameterStep gitParameterStep) throws RepositoryException {
        try {
            ProjectIndex projectIndex = gitParameterStep.getProjectIndex();
            if (projectIndex == null) {
                return new NoOpGitRepositoryDebugDumper();
            }
            ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)connectorBaseParameterStep.getProjectId());
            if (!DebugDumperRegistry.isEnabled((EDebugDumpEvent)EDebugDumpEvent.GIT_TRIGGERED_ROLLBACK, (ProjectInfo)projectInfo)) {
                return new NoOpGitRepositoryDebugDumper();
            }
            return new GitRepositoryDebugDumper(projectInfo, connectorBaseParameterStep.getDefaultBranchName(), connectorBaseParameterStep.getBranchPatternSupport(), gitParameterStep.getImportantBranchPatterns(), connectorBaseParameterStep.getStartDateOrRevision(), connectorBaseParameterStep.getEndDateOrRevision(), connectorBaseParameterStep.isBranchingEnabled(), DebugDumperRegistry.isAnonymizationEnabled(), (Boolean)TeamscaleSystemProperties.GIT_KEEP_RESURRECTED_BRANCH_HISTORY.getValue());
        }
        catch (StorageException e) {
            LOGGER.error("Could not create Git Repository Debug Dumper", (Throwable)e);
            return new NoOpGitRepositoryDebugDumper();
        }
    }
}

