/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.rest.client.authentication.ERestClientAuthenticationMode;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.comments.ReviewCommentEngine;
import com.teamscale.index.merge_request.comments.ReviewCommentEngineParameters;
import com.teamscale.index.merge_request.comments.cluster.IFindingClusterStrategy;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.IVotingInput;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.gerrit.GerritAnalysisResultUploader;
import com.teamscale.index.repository.git.gerrit.GerritConfigurationParameters;
import com.teamscale.index.repository.git.gerrit.GerritFindingBlacklistTrigger;
import com.teamscale.index.repository.git.gerrit.GerritIndexParameters;
import com.teamscale.index.repository.git.gerrit.GerritPatchSetInfo;
import com.teamscale.index.repository.git.gerrit.GerritUtils;
import com.teamscale.index.repository.git.gerrit.GerritVotingInput;
import com.teamscale.index.repository.git.gerrit.GerritVotingSkippedException;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

public class GerritAnalysisResultUploadTrigger
extends CommitVotingTriggerBase<VotingInput> {
    private @Nullable ConnectorConfiguration connector;

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.GERRIT;
    }

    @Override
    protected Pair<MergeRequest, VotingInput> calculateVotingInput(CommitVotingTriggerBase.SchedulingParameters schedulingParams) throws StorageException, VotingException {
        if (!GerritUtils.isGerritBranch(schedulingParams.schedulingCommit().getBranchName())) {
            throw GerritVotingSkippedException.notAGerritBranch(schedulingParams.schedulingCommit());
        }
        this.connector = schedulingParams.connector();
        Optional<ExternalCredentials> accountCredentialsOptional = GerritAnalysisResultUploadTrigger.getGerritAccountCredentials(this.connector, this.indexLayer);
        if (accountCredentialsOptional.isEmpty()) {
            throw new VotingException.Error(schedulingParams.schedulingCommit(), "Gerrit account credentials not found");
        }
        ExternalCredentials externalCredentials = accountCredentialsOptional.get();
        GerritConfigurationParameters gerritConfigurationParameters = new GerritConfigurationParameters(CcpIntegrationFeatureEnablements.isIgnoreYellowFindingsForVotesEnabled(this.connector), CcpIntegrationFeatureEnablements.isIgnoreYellowFindingsForCommentsEnabled(this.connector), CcpIntegrationFeatureEnablements.isDetailedLineCommentsForFindingsEnabled(this.connector), CcpIntegrationFeatureEnablements.isVotingForFindingsEnabled(this.connector));
        ReviewCommentEngineParameters reviewCommentTriggerParameters = this.createReviewCommentTriggerParameters(schedulingParams.schedulingCommit());
        IFindingClusterStrategy findingClusterStrategy = IFindingClusterStrategy.create(CcpIntegrationFeatureEnablements.isCommentAggregationEnabled(this.connector), reviewCommentTriggerParameters);
        ReviewCommentEngine reviewCommentEngine = ReviewCommentEngine.create(reviewCommentTriggerParameters, findingClusterStrategy, this.repositoryPathView, schedulingParams.schedulingCommit(), schedulingParams.linkProvider());
        TrackedFindingsByIdIndex latestVotedPatchSetFindingsIndex = this.getTrackedFindingsByIdIndexForLatestVotedPatchSet(GerritUtils.parseGerritBranch(schedulingParams.schedulingCommit().getBranchName()), schedulingParams.schedulingCommit());
        GerritIndexParameters indexes = this.createGerritIndexParameters(schedulingParams);
        GerritAnalysisResultUploader gerritAnalysisResultUploader = new GerritAnalysisResultUploader(schedulingParams.schedulingCommit(), this.jobDescriptor.getParameter(), GerritAnalysisResultUploadTrigger.getReviewLabel(this.connector), GerritAnalysisResultUploadTrigger.getRestClientAuthenticationMode(this.connector), indexes, reviewCommentTriggerParameters.getTrackedFindingsByIdIndex(), latestVotedPatchSetFindingsIndex, gerritConfigurationParameters, schedulingParams.linkProvider(), externalCredentials, VotingConnectorUtils.getOnFileVoteIncludeExcludePatterns(this.connector), this.connector.getIdentifier(), reviewCommentEngine, CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(this.connector), this.getIndexLayer(), this.getProjectId(), CcpIntegrationFeatureEnablements.isCommitAlertsIntegrationEnabled(schedulingParams.connector()));
        GerritVotingInput votingInput = gerritAnalysisResultUploader.calculateVotingInput();
        return Pair.createPair((Object)votingInput.mergeRequest, (Object)new VotingInput(gerritAnalysisResultUploader, gerritAnalysisResultUploader.calculateVotingInput()));
    }

    private TrackedFindingsByIdIndex getTrackedFindingsByIdIndexForLatestVotedPatchSet(GerritPatchSetInfo currentPatchSet, CommitDescriptor schedulingCommit) throws StorageException, VotingException.Error {
        String changeBranchNamePrefix = currentPatchSet.getChangeBranchNamePrefix();
        CommitTree commitTree = this.getCommitTree(GerritFindingBlacklistTrigger.getGerritRepositoryConnector(this.metaIndex));
        List<GerritPatchSetInfo> patchSets = commitTree.getAllKnownBranchNames().stream().filter(branchName -> branchName.startsWith(changeBranchNamePrefix)).map(GerritUtils::parseGerritBranch).sorted(Comparator.reverseOrder()).toList();
        if (!currentPatchSet.equals(patchSets.get(0))) {
            throw new VotingException.Error(schedulingCommit, "Unexpectedly encountered newer Gerrit patch set while voting: " + String.valueOf(patchSets.get(0)));
        }
        for (int i = 1; i < patchSets.size(); ++i) {
            AnalysisState analysisState;
            String gerritBranchName = patchSets.get(i).getBranchName();
            PairList<CommitDescriptor, VotingRecord> allRecordsForBranch = this.votingRecordIndex.getAllRecordsForBranch(gerritBranchName);
            if (allRecordsForBranch.extractSecondList().stream().noneMatch(votingRecord -> votingRecord.getState() == VotingRecord.EVotingState.VOTED) || (analysisState = this.analysisStateIndex.getAnalysisState(gerritBranchName)) == null || analysisState.getState() != EAnalysisState.LIVE_ANALYSIS) continue;
            return (TrackedFindingsByIdIndex)this.openIndexInProject(TrackedFindingsByIdIndex.class, HistoryAccessOption.readHead((String)gerritBranchName));
        }
        return null;
    }

    @Override
    protected void persistVotingInput(VotingInput input) throws StorageException {
        GerritAnalysisResultUploader gerritAnalysisResultUploader = input.uploader();
        gerritAnalysisResultUploader.persistVotingInput(input.input());
    }

    @Override
    protected VotingRecord.EVotingState performVoting(CommitVotingTriggerBase.SchedulingParameters schedulingParams, VotingInput input) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        GerritVotingInput votingInput = input.input();
        votingInput.findingsCommentsLimit = VotingConnectorUtils.getDetailedLineCommentsLimitForFindings(schedulingParams.connector());
        GerritAnalysisResultUploader gerritAnalysisResultUploader = input.uploader();
        return gerritAnalysisResultUploader.uploadVotingInput(votingInput);
    }

    private GerritIndexParameters createGerritIndexParameters(CommitVotingTriggerBase.SchedulingParameters schedulingParams) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.jobDescriptor.getInternalProjectId());
        GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
        return new GerritIndexParameters((ProjectStorageSystem)projectStorageSystem, globalStorageSystem, schedulingParams.getHistoryAccessOption(), this.getParallelTaskExecutor());
    }

    @Override
    protected boolean isRelevantCommit(CommitDescriptor commit) throws StorageException {
        String branchName = commit.getBranchName();
        if (!GerritUtils.isGerritBranch(branchName)) {
            return false;
        }
        RepositoryLogEntryAggregate entry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(commit);
        if (entry != null && entry.containsRepositoryIdentifier(identifier -> StringUtils.startsWith((CharSequence)identifier, (CharSequence)"Finding flagging uploads"))) {
            return false;
        }
        GerritPatchSetInfo patchSet = GerritUtils.parseGerritBranch(branchName);
        String changeBranchNamePrefix = patchSet.getChangeBranchNamePrefix();
        CommitTree commitTree = this.getCommitTree(GerritFindingBlacklistTrigger.getGerritRepositoryConnector(this.metaIndex));
        List gerritPatchSetBranches = CollectionUtils.filter((Collection)commitTree.getAllKnownBranchNames(), knownBranchName -> knownBranchName.startsWith(changeBranchNamePrefix));
        Optional<GerritPatchSetInfo> latestPatchSet = GerritUtils.determineLatestPatchSet(gerritPatchSetBranches);
        return latestPatchSet.isPresent() && latestPatchSet.get().equals(patchSet);
    }

    @Override
    protected boolean isRelevantLogEntry(RepositoryLogEntryAggregate repositoryLogEntry) throws StorageException {
        return this.getVotingConnector(repositoryLogEntry).isPresent();
    }

    public static Optional<ExternalCredentials> getGerritAccountCredentials(ConnectorConfiguration gerritConnector, IndexLayer indexLayer) throws StorageException {
        return Optional.ofNullable(((ExternalCredentialsIndex)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class)).getExternalCredentials(Objects.requireNonNull(gerritConnector.getOptionValue("Account"))));
    }

    public static ERestClientAuthenticationMode getRestClientAuthenticationMode(ConnectorConfiguration gerritConnector) {
        return ERestClientAuthenticationMode.fromId((String)gerritConnector.getOptionValue("Authentication Mode"));
    }

    private static String getReviewLabel(ConnectorConfiguration gerritConnector) {
        String reviewLabel = gerritConnector.getOptionValue("Review Label");
        return Optional.ofNullable(reviewLabel).orElse("Code-Review");
    }

    @Override
    protected MergeRequest getMergeRequest(VotingInput gerritAnalysisResultUploaderGerritVotingInputPair) {
        return gerritAnalysisResultUploaderGerritVotingInputPair.input().mergeRequest;
    }

    @Override
    protected List<CommitTreeNode> getCommitTreeNodes(VotingInput gerritAnalysisResultUploaderGerritVotingInputPair) throws StorageException {
        CCSMAssert.isNotNull((Object)this.connector, (String)"Connector should never be null after calculating voting input.");
        return this.getCommitTree(this.connector).getAllNodes();
    }

    protected record VotingInput(GerritAnalysisResultUploader uploader, GerritVotingInput input) implements IVotingInput
    {
    }
}

