/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.google.common.net.UrlEscapers;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.rest.client.authentication.ERestClientAuthenticationMode;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.VoteSupportingGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.gerrit.GerritAnalysisResultUploadTrigger;
import com.teamscale.index.repository.git.gerrit.GerritChangeRetriever;
import com.teamscale.index.repository.git.gerrit.GerritContentUpdater;
import com.teamscale.index.repository.git.gerrit.GerritFindingBlacklistTrigger;
import com.teamscale.index.repository.git.gerrit.GerritRestClient;
import com.teamscale.index.repository.git.gerrit.data.ProjectInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.index.shared.RepositoryException;
import org.jetbrains.annotations.VisibleForTesting;

@ConnectorDescriptor
public class GerritRepositoryConnectorDescriptor
extends VoteSupportingGitRepositoryConnectorDescriptorBase {
    static final String VOTE_INCLUDE_PATTERNS_PARAMETER_NAME = "vote-includes";
    static final String VOTE_EXCLUDE_PATTERNS_PARAMETER_NAME = "vote-excludes";
    public static final String REVIEW_LABEL_PARAMETER = "review";
    public static final String ENABLE_VOTING_PARAMETER = "enable-voting";
    public static final String DETAILED_LINE_COMMENTS_ENABLED_PARAMETER = "detailed-line-comments";
    public static final String COMMENT_AGGREGATION_ENABLED_PARAMETER = "comment-aggregation";
    public static final String IGNORE_YELLOW_FINDINGS_FOR_COMMENTS_ENABLED_PARAMETER = "ignore-yellow-findings-for-comments";
    public static final String IGNORE_YELLOW_FINDINGS_FOR_VOTES_ENABLED_PARAMETER = "ignore-yellow-findings-for-votes";
    public static final String GERRIT_PROJECT_NAME = "Project Name";
    public static final String REVIEW_LABEL_DEFAULT = "Code-Review";
    public static final String REVIEW_LABEL_OPTION_NAME = "Review Label";
    public static final String MINIMUM_CHANGE_CREATION_DATE_OPTION_NAME = "Minimum Change Creation Date";
    private static final String FETCH_MERGED_CHANGES_OPTION_NAME = "Fetch Merged Changes";
    public static final String AUTHENTICATION_MODE_OPTION_NAME = "Authentication Mode";
    @ConfigExposed(name="Project Name", visibility=ConfigExposed.EConfigVisibility.DEFAULT, description="The Gerrit project that should be analyzed", required=true)
    private String project;
    @ConfigExposed(name="Read Timeout", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="The timeout (in seconds) used for reading data from Gerrit.")
    private int readTimeoutSeconds = 360;
    @ConfigExposed(name="Authentication Mode", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="The mode to use for authentication (choose basic fallback mode if regular basic mode does not work)")
    private ERestClientAuthenticationMode authenticationMode = ERestClientAuthenticationMode.BASIC;
    @ConfigExposed(name="Review Label", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="The review label used to upload feedback to Gerrit.")
    private String reviewLabel = "Code-Review";
    @ConfigExposed(name="Minimum Change Creation Date", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="If this is set, the first analysis run will only consider open changes created after the given date. Changes that have been closed before the time of the first analysis run will be discarded completely.")
    private String minimumCreationDate;
    @ConfigExposed(name="Fetch Merged Changes", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="If this is set, merged changes are also fetched.")
    private boolean fetchMergedChanges;

    public GerritRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.GERRIT);
        this.autoExpose();
        this.hideOption("Enable Findings Badges");
        this.hideOption("Skip Voting on merge requests without relevant changes");
        this.hideOption("Enable Test Gap Badges");
        this.hideOption("Add Detailed Line Comments for Test Gaps");
        this.hideOption("Add Test Gaps Summary in a Single Comment");
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return GerritChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return GerritContentUpdater.class;
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        triggerBuilder.setTriggerParameter("gerrit-project", this.project);
        triggerBuilder.setTriggerParameter("read-timeout", this.readTimeoutSeconds);
        this.setRevisionParameter(MINIMUM_CHANGE_CREATION_DATE_OPTION_NAME, "minimum-creation-date-and-revision", this.minimumCreationDate, triggerBuilder, triggerCreator);
        super.setCommonParameters(triggerBuilder, triggerCreator);
    }

    @Override
    protected void setChangeRetrieverParameters(TriggerBuilder trigger) throws ProjectConfigurationException {
        super.setChangeRetrieverParameters(trigger);
        trigger.setTriggerParameter("fetch-merged-changes", this.fetchMergedChanges);
    }

    protected void initInternal() {
        if (StringUtils.startsWithIgnoreCase((CharSequence)this.project, (CharSequence)"a/") && !StringUtils.startsWithIgnoreCase((CharSequence)this.project, (CharSequence)"a/a/")) {
            this.project = "a/" + this.project;
        }
        super.initInternal();
    }

    @Override
    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        return GerritRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(this.getRepositoryUri().toString(), "plugins/gitiles", this.project, "+/{commitId}");
    }

    @Override
    protected String getCommitInMergeRequestLinkTemplate() throws ConnectorValidationException {
        return this.getCommitLinkTemplate();
    }

    @Override
    protected void validateRemoteRepository(URI repositoryUri) throws RepositoryException, ConnectorValidationException {
        if (org.conqat.lib.commons.string.StringUtils.isEmpty((String)this.project)) {
            throw new ConnectorValidationException("No Gerrit project was specified");
        }
        if (!this.existsProject()) {
            throw new ConnectorValidationException("The specified project '" + this.project + "' is not a valid Gerrit project");
        }
        super.validateRemoteRepository(repositoryUri);
    }

    private boolean existsProject() throws ConnectorValidationException {
        ExternalCredentials externalCredentials = this.resolveExternalCredentials();
        GerritRestClient gerritRestClient = new GerritRestClient(externalCredentials.uri, externalCredentials.username, externalCredentials.password, Collections.emptyList(), this.readTimeoutSeconds, this.authenticationMode);
        for (ProjectInfo projectInfo : gerritRestClient.getProjects()) {
            if (!projectInfo.getId().equals(UrlEscapers.urlPathSegmentEscaper().escape(org.conqat.lib.commons.string.StringUtils.stripPrefix((String)this.project, (String)"a/")))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        TriggerBuilder blackListFindingTriggerBuilder = this.buildTrigger();
        blackListFindingTriggerBuilder.renameIndex("commit-tree", CommitTreeIndex.getIndexNameForRepository((String)this.repositoryIdentifier));
        if (!triggerCreator.isTriggerAlreadyCreated(blackListFindingTriggerBuilder.getSimpleTriggerName())) {
            triggerCreator.createTrigger(blackListFindingTriggerBuilder);
        }
    }

    @Override
    public Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass() {
        return GerritAnalysisResultUploadTrigger.class;
    }

    private TriggerBuilder buildTrigger() {
        TriggerBuilder trigger = new TriggerBuilder(GerritFindingBlacklistTrigger.class, ETriggerConcurrency.PARALLEL);
        trigger.setTriggerParameter(IGNORE_YELLOW_FINDINGS_FOR_VOTES_ENABLED_PARAMETER, this.ignoreYellowFindingsForVotesEnabled);
        trigger.setTriggerParameter(IGNORE_YELLOW_FINDINGS_FOR_COMMENTS_ENABLED_PARAMETER, this.ignoreYellowFindingsForCommentsEnabled);
        trigger.setTriggerParameter(ENABLE_VOTING_PARAMETER, this.findingsIntegrationEnabled && this.findingsVotingEnabled);
        trigger.setTriggerParameter(DETAILED_LINE_COMMENTS_ENABLED_PARAMETER, this.findingsIntegrationEnabled && this.findingsDetailedLineCommentsEnabled);
        trigger.setTriggerParameter(COMMENT_AGGREGATION_ENABLED_PARAMETER, this.commentAggregationEnabled);
        trigger.setTriggerParameter(REVIEW_LABEL_PARAMETER, this.reviewLabel);
        trigger.setTriggerParameter("authentication-mode", ITriggerParameter.of((Object)this.authenticationMode));
        trigger.setTriggerParameter("account-identifier", this.getAccountIdentifier());
        trigger.setTriggerParameter(VOTE_INCLUDE_PATTERNS_PARAMETER_NAME, ITriggerParameter.of((Object)this.voteIncludePatterns));
        trigger.setTriggerParameter(VOTE_EXCLUDE_PATTERNS_PARAMETER_NAME, ITriggerParameter.of((Object)this.voteExcludePatterns));
        return trigger;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        this.validateRevisionOrDate(this.minimumCreationDate, "minimum-creation-date-and-revision");
    }

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        try {
            return new URI(org.conqat.lib.commons.string.StringUtils.ensureEndsWith((String)super.getRepositoryUri().toString(), (String)"/")).resolve(org.conqat.lib.commons.string.StringUtils.ensureEndsWith((String)this.project, (String)"/"));
        }
        catch (URISyntaxException e) {
            throw new ConnectorValidationException("Could not resolve repository URI " + org.conqat.lib.commons.string.StringUtils.ensureEndsWith((String)super.getRepositoryUri().toString(), (String)"/") + " and project " + this.project, (Throwable)e);
        }
    }

    public String getGerritProjectName() {
        return this.project;
    }

    public static String getGerritProjectName(ConnectorConfiguration connectorConfiguration) {
        return connectorConfiguration.getOptionValue(GERRIT_PROJECT_NAME);
    }

    @VisibleForTesting
    public void setGerritProjectName(String projectName) {
        this.project = projectName;
    }
}

