/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitea;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.common.WebHookBasedGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.gitea.GiteaChangeRetriever;
import com.teamscale.index.repository.git.gitea.GiteaClient;
import com.teamscale.index.repository.git.gitea.GiteaContentUpdater;
import com.teamscale.index.repository.git.gitea.GiteaMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.gitea.GiteaMergeRequestSynchronizer;
import com.teamscale.index.repository.git.gitea.GiteaUtils;
import com.teamscale.index.repository.git.gitea.data.GiteaRepositoryPermissions;
import com.teamscale.index.repository.git.gitea.data.GiteaWebhook;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

@ConnectorDescriptor
public class GiteaRepositoryConnectorDescriptor
extends WebHookBasedGitRepositoryConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String GITEA_WEBHOOK_ENDPOINT = "api/gitea/web-hook";

    public GiteaRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.GITEA, LOGGER);
        this.defaultBranchName = "main";
        this.autoExpose();
    }

    @Override
    public Class<? extends AnalysisStepBase> getPullRequestSynchronizerClass() {
        return GiteaMergeRequestSynchronizer.class;
    }

    @Override
    public Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass() {
        return GiteaMergeRequestAnnotationTrigger.class;
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return GiteaChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return GiteaContentUpdater.class;
    }

    @Override
    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        return GiteaRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(super.getRepositoryUri().toString(), this.getRepositoryName(), "commit/{commitId}");
    }

    @Override
    protected String getCommitInMergeRequestLinkTemplate() throws ConnectorValidationException {
        return GiteaRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(super.getRepositoryUri().toString(), this.getRepositoryName(), "pulls/{mergeRequestId}/commits/{commitId}");
    }

    private @NonNull GiteaClient getClient() throws ConnectorValidationException {
        ExternalCredentials credentials = this.resolveExternalCredentials();
        return new GiteaClient(super.getRepositoryUri().toString(), credentials.username, credentials.password, LOGGER);
    }

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        return this.parseUri(GiteaUtils.getRepositoryCloneUrl(this.getClient(), this.repositoryName));
    }

    @Override
    protected void ensureHookIsConfigured(ServerOptionIndex serverOptionIndex) throws StorageException, ServiceCallException, ConnectorValidationException {
        String webhookUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex) + GITEA_WEBHOOK_ENDPOINT;
        String[] expectedEvents = new String[]{"push", "pull_request"};
        PlatformRepositoryIdentifier repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName(this.getRepositoryName());
        GiteaClient client = this.getClient();
        List<GiteaWebhook> webhooks = client.getRepositoryWebhooks(repositoryIdentifier);
        boolean hasMatchingHook = webhooks.stream().anyMatch(webhook -> webhookUrl.equals(webhook.config().url()) && webhook.active() && CollectionUtils.asHashSet((Object[])webhook.events()).containsAll(Arrays.asList(expectedEvents)));
        if (hasMatchingHook) {
            return;
        }
        String[] eventsToRegister = new String[]{"push", "pull_request_only"};
        client.createRepositoryWebhook(repositoryIdentifier, webhookUrl, eventsToRegister);
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        GitRepositoryManagementConnectorDescriptorBase.splitRepositoryName(this.getRepositoryName(), ConnectorValidationException::new);
        this.validatePermissions();
    }

    private void validatePermissions() throws ConnectorValidationException {
        boolean isVotingEnabled;
        boolean bl = isVotingEnabled = this.findingsIntegrationEnabled && this.findingsVotingEnabled;
        if (this.disableAutomaticWebhookCreation && !isVotingEnabled) {
            return;
        }
        GiteaRepositoryPermissions permissions = this.fetchRepositoryPermissions();
        if (permissions.admin()) {
            return;
        }
        String missingPermissionMessage = "Missing permissions! Teamscale needs %1$s for %2$s. Please either disable %2$s or grant the required permissions.";
        if (!this.disableAutomaticWebhookCreation) {
            throw new ConnectorValidationException(String.format(missingPermissionMessage, "admin access to the repository", "automatic webhook creation"));
        }
        if (isVotingEnabled && !permissions.push()) {
            throw new ConnectorValidationException(String.format(missingPermissionMessage, "write access to the code of the repository", "'Voting for Findings'"));
        }
    }

    private GiteaRepositoryPermissions fetchRepositoryPermissions() throws ConnectorValidationException {
        try {
            return this.getClient().getRepository(PlatformRepositoryIdentifier.fromRepositoryName(this.getRepositoryName())).permissions();
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException("Could not fetch information about the repository to validate the required permissions.", (Throwable)e);
        }
    }
}

