/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import com.teamscale.index.repository.git.cross_repo_merge_requests.ICrossRepositoryMergeRequestHandler;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.github.data.GitHubRepository;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class GitHubCrossRepositoryMergeRequestHandler
implements ICrossRepositoryMergeRequestHandler<GitHubPullRequest> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public CrossRepositoryMergeRequestSourceBranch getSourceBranch(@NonNull GitHubPullRequest pullRequest) {
        Pair sourceIdentifierAndRemoteSourceBranch = StringUtils.splitAtFirst((String)GitHubCrossRepositoryMergeRequestHandler.getHeadLabel(pullRequest), (char)':');
        return new CrossRepositoryMergeRequestSourceBranch(pullRequest.number(), (String)sourceIdentifierAndRemoteSourceBranch.getFirst(), (String)sourceIdentifierAndRemoteSourceBranch.getSecond());
    }

    @Override
    public boolean isCrossRepositoryMergeRequest(@NonNull GitHubPullRequest pullRequest) {
        return GitHubCrossRepositoryMergeRequestHandler.isCrossRepoMergeRequest(pullRequest);
    }

    private static String getHeadLabel(@NonNull GitHubPullRequest pullRequest) {
        return pullRequest.head().label();
    }

    public static boolean isCrossRepoMergeRequest(@NonNull GitHubPullRequest pullRequest) {
        GitHubRepository headRepo = pullRequest.head().repo();
        GitHubRepository baseRepo = pullRequest.base().repo();
        if (headRepo == null || baseRepo == null) {
            LOGGER.debug("Source or target repository for pull request {} could not be found. Head ref is '{}', base ref is '{}'. This will not be handled as a cross-repository pull request.", (Object)pullRequest.number(), (Object)pullRequest.head().branchName(), (Object)pullRequest.base().branchName());
            return false;
        }
        return !Objects.equals(headRepo.fullName(), baseRepo.fullName());
    }
}

