/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.MergeRequestBuildJobHandler;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.CheckRunBuilder;
import com.teamscale.index.repository.git.github.data.GitHubBuildJob;
import com.teamscale.index.repository.git.github.data.GitHubCommitStatus;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.GitHubDataFetchConfiguration;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.GitHubMergeRequestDataFetchStrategyFactory;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.IGitHubMergeRequestDataFetchStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class GitHubMergeRequestBuildJobHandler
extends MergeRequestBuildJobHandler<GitHubBuildJob> {
    private final PlatformRepositoryIdentifier repositoryIdentifier;
    private final String contextIdentifier;
    private final IGitHubMergeRequestDataFetchStrategy dataFetchStrategy;

    public GitHubMergeRequestBuildJobHandler(GitHubDataFetchConfiguration dataFetchConfiguration, IncludeExcludeRegexSupport buildIncludeExcludeRegexSupport, PlatformRepositoryIdentifier repositoryIdentifier, String contextIdentifier) {
        super(buildIncludeExcludeRegexSupport);
        this.repositoryIdentifier = repositoryIdentifier;
        this.contextIdentifier = contextIdentifier;
        this.dataFetchStrategy = GitHubMergeRequestDataFetchStrategyFactory.create(dataFetchConfiguration);
    }

    @Override
    protected List<GitHubBuildJob> getPlatformMergeRequestBuildJobs(String mergeRequestSourceHead) throws ServiceCallException {
        try {
            ArrayList<GitHubBuildJob> allBuildJobs = new ArrayList<GitHubBuildJob>();
            allBuildJobs.addAll(this.getMatchingCheckRuns(mergeRequestSourceHead));
            allBuildJobs.addAll(this.getMatchingCommitStatuses(mergeRequestSourceHead));
            return allBuildJobs;
        }
        catch (StorageException e) {
            throw new ServiceCallException((Throwable)e);
        }
    }

    private Collection<GitHubBuildJob> getMatchingCheckRuns(String mergeRequestSourceHead) throws ServiceCallException, StorageException {
        Collection<CheckRun> allCheckRuns = this.dataFetchStrategy.getCheckRuns(this.repositoryIdentifier, mergeRequestSourceHead);
        Set<String> teamscaleCheckRunNames = CheckRunBuilder.getTeamscaleCheckRunNames(this.contextIdentifier);
        List matchingCheckRuns = CollectionUtils.filter(allCheckRuns, checkRun -> !teamscaleCheckRunNames.contains(checkRun.name()) && this.buildIncludeExcludeRegexSupport.isIncluded(checkRun.name()));
        return CollectionUtils.map((Collection)matchingCheckRuns, checkRun -> GitHubBuildJob.fromCheckRun(checkRun, LogManager.getLogger()));
    }

    private Collection<GitHubBuildJob> getMatchingCommitStatuses(String mergeRequestSourceHead) throws ServiceCallException, StorageException {
        Collection<GitHubCommitStatus> allCommitStatuses = this.dataFetchStrategy.getCommitStatuses(this.repositoryIdentifier, mergeRequestSourceHead);
        return allCommitStatuses.stream().filter(commitStatus -> this.buildIncludeExcludeRegexSupport.isIncluded(commitStatus.context())).map(GitHubBuildJob::new).toList();
    }
}

