/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.merge_request.MergeRequestSynchronizerBase;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.base.IncludeExcludeStepParameter;
import com.teamscale.index.repository.git.gitlab.GitLabChangeRetriever;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestProvider;
import com.teamscale.index.repository.git.gitlab.data.GitLabMergeRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.persistence.store.StorageException;

@AnalysisStep
public class GitLabMergeRequestSynchronizer
extends MergeRequestSynchronizerBase<GitLabMergeRequestProvider, GitLabMergeRequest> {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="repository-name")
    private String repositoryName;
    @StepParameter(value="account-identifier")
    private String accountIdentifier;
    @StepParameterObject(namePrefix="build-")
    private final IncludeExcludeStepParameter<IncludeExcludeRegexSupport> buildIncludeExcludeRegexSupport = new IncludeExcludeStepParameter<IncludeExcludeRegexSupport>(IncludeExcludeRegexSupport::new);

    @Override
    protected GitLabMergeRequestProvider createMergeRequestProvider() throws StorageException {
        ExternalCredentials credentials = this.getExternalCredentials(this.accountIdentifier);
        GitLabClient client = new GitLabClient(credentials.uri, credentials.password, LOGGER);
        return new GitLabMergeRequestProvider(this.repositoryName, client, this.buildIncludeExcludeRegexSupport.get());
    }

    @Override
    protected String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    protected Class<? extends RepositoryChangeRetrieverBase> getChangeRetrieverClass() {
        return GitLabChangeRetriever.class;
    }
}

