/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.repository.git.scm_manager.data.ScmFindingsBadge;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerCiStatus;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerDiff;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerPullRequestComments;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerPullRequests;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerRepository;
import com.teamscale.index.repository.git.scm_manager.data.ScmTeamscalePluginUrl;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public interface IScmManagerApi
extends IRetrofitApi {
    public static final String TEAMSCALE_PULL_REQUEST_CONTENT_TYPE = "application/vnd.scmm-teamscalePullRequest+json;v=2";
    public static final String ACCEPT_TEAMSCALE_PULL_REQUEST_HEADER = "Accept: application/vnd.scmm-teamscalePullRequest+json;v=2";
    public static final String REST_API_BASE_PATH = "api/v2/";
    public static final String TEAMSCALE_PLUGIN_API_BASE_PATH = "api/v2/teamscale/";
    public static final String REPOSITORY_NAMESPACE_PARAMETER_NAME = "namespace";
    public static final String REPOSITORY_NAME_PARAMETER_NAME = "repositoryName";
    public static final String PULL_REQUEST_ID_PARAMETER_NAME = "pullRequestId";
    public static final String CI_STATUS_TYPE_PARAMETER_NAME = "ciStatusType";
    public static final String CI_STATUS_NAME_PARAMETER_NAME = "ciStatusName";
    public static final String SOURCE_BRANCH_PARAMETER_NAME = "sourceBranch";
    public static final String TARGET_BRANCH_PARAMETER_NAME = "targetBranch";
    public static final String COMMENT_ID_PARAMETER_NAME = "commentId";
    public static final String REPOSITORY_IDENTIFIER_PATH_SEGMENT = "{namespace}/{repositoryName}";
    public static final String REPOSITORY_API_ENDPOINT = "api/v2/repositories/{namespace}/{repositoryName}";
    public static final String PULL_REQUESTS_API_ENDPOINT = "api/v2/teamscale/pull-request/{namespace}/{repositoryName}";
    public static final String SINGLE_PULL_REQUEST_API_ENDPOINT = "api/v2/teamscale/pull-request/{namespace}/{repositoryName}/{pullRequestId}";
    public static final String PULL_REQUEST_FINDINGS_BADGE_API_ENDPOINT = "api/v2/teamscale/pull-request/{namespace}/{repositoryName}/{pullRequestId}/findings";
    public static final String PULL_REQUEST_COMMENTS_API_ENDPOINT = "api/v2/teamscale/pull-request/comments/{namespace}/{repositoryName}/{pullRequestId}";
    public static final String SINGLE_PULL_REQUEST_COMMENT_API_ENDPOINT = "api/v2/teamscale/pull-request/comments/{namespace}/{repositoryName}/{pullRequestId}/{commentId}";
    public static final String PULL_REQUEST_CI_STATUS_API_ENDPOINT = "api/v2/ci/{namespace}/{repositoryName}/pullrequest/{pullRequestId}/{ciStatusType}/{ciStatusName}";
    public static final String TEAMSCALE_PLUGIN_CONFIGURATION_API_ENDPOINT = "api/v2/teamscale/configuration/{namespace}/{repositoryName}";
    public static final String DIFF_API_ENDPOINT = "api/v2/repositories/{namespace}/{repositoryName}/incoming/{sourceBranch}/{targetBranch}/diff/parsed";

    @Headers(value={"Accept: application/vnd.scmm-repository+json;v=2"})
    @GET(value="api/v2/repositories/{namespace}/{repositoryName}")
    public ScmManagerRepository getRepository(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2) throws ServiceCallException;

    @Headers(value={"Accept: application/vnd.scmm-teamscalePullRequest+json;v=2"})
    @GET(value="api/v2/teamscale/pull-request/{namespace}/{repositoryName}/{pullRequestId}")
    public ScmManagerPullRequests.PullRequest getPullRequest(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2, @Path(value="pullRequestId") long var3) throws ServiceCallException;

    @Headers(value={"Content-Type: application/vnd.scmm-cistatus+json;v=2"})
    @PUT(value="api/v2/ci/{namespace}/{repositoryName}/pullrequest/{pullRequestId}/{ciStatusType}/{ciStatusName}")
    public Void putCiStatus(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2, @Path(value="pullRequestId") long var3, @Path(value="ciStatusType") String var5, @Path(value="ciStatusName") String var6, @Body ScmManagerCiStatus.CiStatus var7) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="api/v2/teamscale/configuration/{namespace}/{repositoryName}")
    public Void putTeamscaleInstanceUrl(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2, @Body ScmTeamscalePluginUrl var3) throws ServiceCallException;

    @Headers(value={"Content-Type: application/vnd.scmm-teamscaleFindings+json;v=2"})
    @PUT(value="api/v2/teamscale/pull-request/{namespace}/{repositoryName}/{pullRequestId}/findings")
    public Void putFindingsBadge(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2, @Path(value="pullRequestId") long var3, @Body ScmFindingsBadge var5) throws ServiceCallException;

    @GET(value="api/v2/teamscale/pull-request/{namespace}/{repositoryName}/{pullRequestId}/findings")
    public ScmFindingsBadge getFindingsBadge(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2, @Path(value="pullRequestId") long var3) throws ServiceCallException;

    @Headers(value={"Accept: application/vnd.scmm-teamscalePullRequest+json;v=2"})
    @GET(value="api/v2/teamscale/pull-request/{namespace}/{repositoryName}?status=OPEN")
    public ScmManagerPullRequests.PullRequests getOpenPullRequests(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2) throws ServiceCallException;

    @Headers(value={"Accept: application/vnd.scmm-diffParsed+json;v=2"})
    @GET(value="api/v2/repositories/{namespace}/{repositoryName}/incoming/{sourceBranch}/{targetBranch}/diff/parsed")
    public ScmManagerDiff.Diff getPullRequestDiff(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2, @Path(value="sourceBranch") String var3, @Path(value="targetBranch") String var4) throws ServiceCallException;

    @Headers(value={"Accept: application/vnd.scmm-teamscalePullRequest+json;v=2"})
    @GET(value="api/v2/teamscale/pull-request/comments/{namespace}/{repositoryName}/{pullRequestId}")
    public ScmManagerPullRequestComments.PullRequestComments getPullRequestComments(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2, @Path(value="pullRequestId") long var3) throws ServiceCallException;

    @Headers(value={"Content-Type: application/vnd.scmm-teamscalePullRequest+json;v=2"})
    @POST(value="api/v2/teamscale/pull-request/comments/{namespace}/{repositoryName}/{pullRequestId}")
    public Void postPullRequestComment(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2, @Path(value="pullRequestId") long var3, @Body ScmManagerPullRequestComments.PullRequestComment var5) throws ServiceCallException;

    @DELETE(value="api/v2/teamscale/pull-request/comments/{namespace}/{repositoryName}/{pullRequestId}/{commentId}")
    public Void deletePullRequestComment(@Path(value="namespace") String var1, @Path(value="repositoryName") String var2, @Path(value="pullRequestId") long var3, @Path(value="commentId") String var5) throws ServiceCallException;
}

