/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.iec;

import com.teamscale.index.repository.ITokenElementInfoExtractor;
import com.teamscale.index.resource.element_details.IECLanguageDetail;
import com.teamscale.index.resource.element_details.STFileType;
import com.teamscale.index.resource.element_details.VariableDeclarationDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StructuredTextElementInfoExtractorPCWORX
implements ITokenElementInfoExtractor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<byte[]> PCWORX_PRODUCT_NAMES = new HashSet(Arrays.asList(StringUtils.stringToBytes((String)"productName=\"PC WORX\""), StringUtils.stringToBytes((String)"productName=\"PC WorX\"")));
    private static final byte[] PCWORX_NAMESPACE = StringUtils.stringToBytes((String)"/xml/PLCopen/TC6_XML_V10_KW.xsd");
    private static final String ST_TYPES_TAG = "<datatypeWorksheet>";
    private static final Map<String, String> POU_TYPES = new HashMap<String, String>();

    @Override
    public BasicTokenElementInfo getElementInfo(ELanguage language, byte[] content, String uniformPath) {
        CCSMAssert.isTrue((boolean)this.canExtractFromSourceFile(language, content, uniformPath), (String)"Tried to extract embedded code with non-applicable extractor.");
        return StructuredTextElementInfoExtractorPCWORX.createStructuredTextElement(uniformPath, content);
    }

    static String stripByteOrderMark(String content) {
        if (content.startsWith("\ufeff")) {
            return content.substring("\ufeff".length());
        }
        return content;
    }

    static BasicTokenElementInfo createStructuredTextElement(String uniformPath, byte[] data) {
        String pouType = null;
        String pouName = null;
        String pouReturnType = null;
        Object structuredText = "";
        ArrayList deletions = new ArrayList();
        List<Object> details = new ArrayList<STFileType>();
        String content = StructuredTextElementInfoExtractorPCWORX.stripByteOrderMark(new String(data, StandardCharsets.UTF_8));
        try {
            Document document = XMLUtils.parse((InputSource)new InputSource(new ByteArrayInputStream(data)));
            if (StructuredTextElementInfoExtractorPCWORX.containsTypesTag(content)) {
                String typesSection = StructuredTextElementInfoExtractorPCWORX.extractTypes(uniformPath, document);
                details = Collections.singletonList(STFileType.TYPES);
                return new BasicTokenElementInfo(uniformPath, ELanguage.IEC61131, false, typesSection, deletions, details);
            }
            structuredText = StructuredTextElementInfoExtractorPCWORX.extractStructuredText(uniformPath, document);
            pouType = POU_TYPES.get(StructuredTextElementInfoExtractorPCWORX.extractPouAttribute(uniformPath, document, "pouType"));
            pouName = StructuredTextElementInfoExtractorPCWORX.extractPouAttribute(uniformPath, document, "name");
            if ("FUNCTION".equals(pouType)) {
                pouReturnType = StructuredTextElementInfoExtractorPCWORX.extractPouReturnType(uniformPath, document);
            }
            details.add((Object)new IECLanguageDetail(StructuredTextElementInfoExtractorPCWORX.extractPouBodyTypes(document)));
            if (!(((String)structuredText).isEmpty() || pouType == null || pouName.isEmpty() || pouType.equals("FUNCTION") && pouReturnType == null)) {
                String prefix = pouType + " " + pouName;
                if (pouType.equals("FUNCTION")) {
                    prefix = prefix + " : " + pouReturnType;
                }
                structuredText = prefix + "\n" + (String)structuredText + "\nEND_" + pouType;
            }
            details.addAll(StructuredTextElementInfoExtractorPCWORX.parseVariableDeclarations(uniformPath, document));
        }
        catch (IOException | SAXException e) {
            LOGGER.warn("Could not parse Structured Text from " + uniformPath, (Throwable)e);
        }
        details.add((Object)STFileType.CODE);
        return new BasicTokenElementInfo(uniformPath, ELanguage.IEC61131, false, (String)structuredText, deletions, details);
    }

    private static String extractTypes(String uniformPath, Document document) {
        String structuredText = "";
        NodeList stNodes = document.getElementsByTagName("datatypeWorksheet");
        if (stNodes.getLength() >= 1) {
            if (stNodes.getLength() > 1) {
                LOGGER.warn("More than one <ST> node in " + uniformPath);
            }
            Element stNode = (Element)XMLUtils.elementNodes((NodeList)stNodes).get(0);
            structuredText = stNode.getTextContent();
        } else {
            LOGGER.warn("No structured text found in " + uniformPath);
        }
        return structuredText;
    }

    private static String extractPouAttribute(String uniformPath, Document document, String attribute) {
        NodeList pouNodes = document.getElementsByTagName("pou");
        if (pouNodes.getLength() >= 1) {
            if (pouNodes.getLength() > 1) {
                LOGGER.warn("More than one <pou> node in " + uniformPath);
            }
            Element pouNode = (Element)pouNodes.item(0);
            return pouNode.getAttribute(attribute);
        }
        return "";
    }

    private static String extractPouReturnType(String uniformPath, Document document) {
        NodeList returnTypeNodes = document.getElementsByTagName("returnType");
        if (returnTypeNodes.getLength() >= 1) {
            if (returnTypeNodes.getLength() > 1) {
                LOGGER.warn("More than one <returnType> node in " + uniformPath);
            }
            return StructuredTextElementInfoExtractorPCWORX.getTypeNameFromChildElement(uniformPath, (Element)returnTypeNodes.item(0));
        }
        return "";
    }

    private static Set<String> extractPouBodyTypes(Document document) {
        HashSet<String> bodyTypes = new HashSet<String>();
        NodeList pouNodes = document.getElementsByTagName("pou");
        for (Element pouElement : XMLUtils.elementNodes((NodeList)pouNodes)) {
            Element bodyElement = XMLUtils.getNamedChild((Element)pouElement, (String)"body");
            for (Element bodyChild : XMLUtils.elementNodes((NodeList)bodyElement.getChildNodes())) {
                bodyTypes.add(bodyChild.getNodeName());
            }
        }
        return bodyTypes;
    }

    private static String extractStructuredText(String uniformPath, Document document) {
        Object structuredText = "";
        NodeList stNodes = document.getElementsByTagName("ST");
        if (stNodes.getLength() >= 1) {
            if (stNodes.getLength() > 1) {
                LOGGER.warn("More than one <ST> node in " + uniformPath);
            }
            Element stNode = (Element)XMLUtils.elementNodes((NodeList)stNodes).get(0);
            List pNodes = XMLUtils.elementNodes((NodeList)stNode.getElementsByTagName("p"));
            for (Element pNode : pNodes) {
                structuredText = (String)structuredText + pNode.getTextContent();
            }
        } else {
            LOGGER.warn("No structured text found in " + uniformPath);
        }
        return structuredText;
    }

    private static List<TokenElementDetailBase> parseVariableDeclarations(String uniformPath, Document document) {
        ArrayList<TokenElementDetailBase> details = new ArrayList<TokenElementDetailBase>();
        VariableDeclarationDetail detail = new VariableDeclarationDetail();
        details.add(detail);
        StructuredTextElementInfoExtractorPCWORX.parseNodes(uniformPath, document, "inputVars", detail::addInputOrOutputVariable);
        StructuredTextElementInfoExtractorPCWORX.parseNodes(uniformPath, document, "localVars", detail::addLocalVariable);
        StructuredTextElementInfoExtractorPCWORX.parseNodes(uniformPath, document, "externalVars", detail::addExternalVariable);
        return details;
    }

    private static void parseNodes(String uniformPath, Document document, String nameOfHead, BiConsumer<String, String> add) {
        NodeList nodes = document.getElementsByTagName(nameOfHead);
        if (nodes.getLength() == 0) {
            return;
        }
        for (Element head : XMLUtils.elementNodes((NodeList)nodes)) {
            for (Element e : XMLUtils.elementNodes((NodeList)head.getElementsByTagName("variable"))) {
                String name = e.getAttribute("name");
                String type = "";
                NodeList typeNodes = e.getElementsByTagName("type");
                if (typeNodes.getLength() < 1) {
                    LOGGER.error("Declararation of variable '" + name + "' in element '" + uniformPath + "' has no nested element <type>. Ignoring the declaration.");
                    continue;
                }
                type = StructuredTextElementInfoExtractorPCWORX.getTypeNameFromChildElement(uniformPath, (Element)typeNodes.item(0));
                if (type == null) continue;
                add.accept(name, type);
            }
        }
    }

    private static String getTypeNameFromChildElement(String uniformPath, Element typeElement) {
        List leaves = XMLUtils.leafElementNodes((Element)typeElement);
        if (leaves.size() < 1) {
            LOGGER.error("No nested element specifying the actual type in " + uniformPath);
            return null;
        }
        Element typeElementChild = (Element)leaves.get(0);
        if ("derived".equals(typeElementChild.getLocalName())) {
            return typeElementChild.getAttribute("name");
        }
        return typeElementChild.getLocalName();
    }

    public static boolean isStructuredTextCodeEmbeddedInXML(ELanguage language, byte[] content) {
        return language == ELanguage.XML && ByteArrayUtils.indexOf((byte[])PCWORX_NAMESPACE, (byte[])content, (int)0, (int)600) != -1 && PCWORX_PRODUCT_NAMES.stream().anyMatch(productName -> ByteArrayUtils.indexOf((byte[])productName, (byte[])content, (int)0, (int)600) != -1);
    }

    public static boolean containsTypesTag(String content) {
        return content.contains(ST_TYPES_TAG);
    }

    @Override
    public boolean canExtractFromSourceFile(ELanguage language, byte[] content, String uniformPath) {
        return StructuredTextElementInfoExtractorPCWORX.isStructuredTextCodeEmbeddedInXML(language, content);
    }

    static {
        POU_TYPES.put("function", "FUNCTION");
        POU_TYPES.put("functionBlock", "FUNCTION_BLOCK");
        POU_TYPES.put("program", "PROGRAM");
    }
}

