/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.rfc;

import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.EUpdateMode;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.rfc.AbapRfcFunctionExecuterBase;
import org.conqat.engine.abap.AbapUtils;

public abstract class AbapExportRfcFunctionExecutorBase
extends AbapRfcFunctionExecuterBase {
    private static final String IMPORT_PARAMETER_EXPORT_CONFIG_ID = "I_EXPORT_CONFIG_ID";
    private static final String IMPORT_PARAMETER_INCLUDE_YZ_NAMESPACE = "I_INCLUDE_YZ_NAMESPACE";
    private static final String IMPORT_PARAMETER_CUSTOM_NAMESPACES = "I_CUSTOM_NAMESPACES";
    private static final String IMPORT_PARAMETER_SCI_VARIANT = "I_SCI_VARIANT";
    private static final String IMPORT_PARAMETER_SCI_USER = "I_SCI_USER";
    private static final String IMPORT_PARAMTER_SCI_INCLUDE_PATTERNS = "I_SCI_INCLUDE_PATTERNS";
    private static final String IMPORT_PARAMTER_SCI_EXCLUDE_PATTERNS = "I_SCI_EXCLUDE_PATTERNS";
    private static final String IMPORT_PARAMETER_IS_FULL_EXPORT = "I_IS_FULL_EXPORT";
    private static final String IMPORT_PARAMETER_INCLUDE_ENHANCMENTS = "I_INCLUDE_ENHANCMENTS";
    private static final String IMPORT_PARAMETER_INCLUDE_DDIC_OBJECTS = "I_INCLUDE_DDIC_OBJECTS";
    private static final String IMPORT_PARAMETER_INCLUDE_BW_OBJECTS = "I_INCLUDE_BW_OBJECTS";
    private static final String IMPORT_PARAMETER_INCLUDE_MODIFICATIONS = "I_INCLUDE_MODIFICATIONS";
    private static final String IMPORT_PARAMETER_INCLUDE_PATHS_FOR_ALL_OBJECTS = "I_INCLUDE_ALL_PATHS";
    private static final String IMPORT_PARAMETER_ADD_TEST_COVERAGE = "I_ADD_TEST_COVERAGE";
    private static final String IMPORT_PARAMETER_CLEAR_TEST_COVERAGE = "I_CLEAR_TEST_COVERAGE";
    private final String exportHistoryId;
    private final EUpdateMode updateMode;

    public AbapExportRfcFunctionExecutorBase(String configurationId, String abapRfcFunctionModule, AbapSystemDescription abapSystemDescription, GlobalSapSystemConnectionOption globalSapOption, String exportHistoryId, EUpdateMode updateMode) {
        super(configurationId, abapRfcFunctionModule, abapSystemDescription, globalSapOption);
        this.exportHistoryId = exportHistoryId;
        this.updateMode = updateMode;
    }

    @Override
    protected void setImportParameters() {
        this.setImportParameter(IMPORT_PARAMETER_EXPORT_CONFIG_ID, this.exportHistoryId);
        this.setImportParameter(IMPORT_PARAMETER_INCLUDE_YZ_NAMESPACE, this.abapSystemDescription.includeDefaultCustomNamespace);
        this.setImportParameter(IMPORT_PARAMETER_CUSTOM_NAMESPACES, this.abapSystemDescription.addtionalCustomNamespaces.toUpperCase());
        this.setImportParameter(IMPORT_PARAMETER_IS_FULL_EXPORT, this.updateMode.isFullExport());
        if (this.updateMode.enableCodeInspector) {
            this.setImportParameter(IMPORT_PARAMETER_SCI_VARIANT, this.abapSystemDescription.codeInspectorVariantName);
            this.setImportParameter(IMPORT_PARAMETER_SCI_USER, this.abapSystemDescription.codeInspectorVariantUser);
            this.setImportParameterIfAvailable(IMPORT_PARAMTER_SCI_INCLUDE_PATTERNS, AbapUtils.convertAntPatternList((String)this.abapSystemDescription.codeInspectorInclude));
            this.setImportParameterIfAvailable(IMPORT_PARAMTER_SCI_EXCLUDE_PATTERNS, AbapUtils.convertAntPatternList((String)this.abapSystemDescription.codeInspectorExclude));
        }
        this.setImportParameterIfAvailable(IMPORT_PARAMETER_INCLUDE_ENHANCMENTS, true);
        this.setImportParameterIfAvailable(IMPORT_PARAMETER_INCLUDE_MODIFICATIONS, this.abapSystemDescription.includeModifications);
        this.setImportParameterIfAvailable(IMPORT_PARAMETER_INCLUDE_PATHS_FOR_ALL_OBJECTS, this.abapSystemDescription.includePathsForAllObjects && this.updateMode.isFullExport());
        this.setImportParameterIfAvailable(IMPORT_PARAMETER_INCLUDE_DDIC_OBJECTS, this.abapSystemDescription.includeDdicObjects);
        this.setImportParameter(IMPORT_PARAMETER_INCLUDE_BW_OBJECTS, this.abapSystemDescription.includeBwObjects);
        if (this.abapSystemDescription.isIncludeTestCoverage(this.updateMode)) {
            this.setImportParameter(IMPORT_PARAMETER_ADD_TEST_COVERAGE, true);
            this.setImportParameter(IMPORT_PARAMETER_CLEAR_TEST_COVERAGE, this.abapSystemDescription.clearTestCoverage);
        }
    }
}

