/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sca;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.sca.BuildComponent;
import com.teamscale.index.repository.sca.NameWithVersion;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class CompositionViolation
implements Serializable {
    public static final String ID_PART_SEPARATOR = "#-#";
    private static final long serialVersionUID = 1L;
    private static final String BUILD_PROPERTY = "build";
    private static final String ID_PROPERTY = "id";
    private static final String VULNERABILITY_ID_PROPERTY = "vulnerabilityId";
    private static final String COMPONENTS_PROPERTY = "components";
    private static final String SUMMARY_PROPERTY = "summary";
    private static final String SEVERITY_PROPERTY = "severity";
    private static final String TYPE_PROPERTY = "type";
    private static final String UPDATED_PROPERTY = "updated";
    private static final String TS_ACCOUNT_IDENTIFIER_PROPERTY = "tsAccountIdentifier";
    private static final String WATCHER_NAME_PROPERTY = "watcherName";
    private static final String EXTERNAL_PROJECT_KEY_PROPERTY = "externalProjectKey";
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="vulnerabilityId")
    private final String vulnerabilityId;
    @JsonProperty(value="build")
    private final NameWithVersion build;
    @JsonProperty(value="components")
    private final List<BuildComponent> components;
    @JsonProperty(value="summary")
    public final String summary;
    @JsonProperty(value="severity")
    public final String severity;
    @JsonProperty(value="type")
    public final String type;
    @JsonProperty(value="updated")
    public final String updated;
    @JsonProperty(value="tsAccountIdentifier")
    public final String tsAccountIdentifier;
    @JsonProperty(value="watcherName")
    public final String watcherName;
    @JsonProperty(value="externalProjectKey")
    public final String externalProjectKey;

    @JsonCreator
    public CompositionViolation(@JsonProperty(value="build") NameWithVersion build, @JsonProperty(value="vulnerabilityId") String vulnerabilityId, @JsonProperty(value="summary") String summary, @JsonProperty(value="severity") String severity, @JsonProperty(value="type") String type, @JsonProperty(value="updated") String updated, @JsonProperty(value="watcherName") String watcherName, @JsonProperty(value="tsAccountIdentifier") String tsAccountIdentifier, @JsonProperty(value="components") List<BuildComponent> components, @JsonProperty(value="externalProjectKey") String externalProjectKey) {
        this.vulnerabilityId = vulnerabilityId;
        this.build = build;
        this.summary = summary;
        this.severity = severity;
        this.type = type;
        this.updated = updated;
        this.tsAccountIdentifier = tsAccountIdentifier;
        this.watcherName = watcherName;
        this.components = components;
        this.externalProjectKey = externalProjectKey;
        this.id = build.name() + ID_PART_SEPARATOR + CompositionViolation.formatComponentsForId(components) + ID_PART_SEPARATOR + vulnerabilityId;
    }

    private static String formatComponentsForId(List<BuildComponent> components) {
        return components.stream().sorted(Comparator.comparing(BuildComponent::name)).map(BuildComponent::componentId).collect(Collectors.joining("-"));
    }

    public NameWithVersion getBuild() {
        return this.build;
    }

    public String getVulnerabilityId() {
        return this.vulnerabilityId;
    }

    public String getId() {
        return this.id;
    }

    public List<BuildComponent> getComponents() {
        return CollectionUtils.asUnmodifiable(this.components);
    }

    public String toString() {
        return this.id;
    }
}

