/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.index.repository.IRevisionResolver;
import com.teamscale.index.repository.svn.SVNRepositoryConnectorDescriptor;
import com.teamscale.index.repository.svn.SVNUtils;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.tmatesoft.svn.core.SVNException;

public class SVNRevisionResolver
implements IRevisionResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SVNRepositoryConnectorDescriptor svnConnectorDescriptor;
    private final ExternalCredentials credentials;
    private final boolean enableBranchAnalysis;
    private final String branchesDirectory;
    private final String pathSuffix;

    public SVNRevisionResolver(ExternalCredentials credentials, SVNRepositoryConnectorDescriptor svnConnectorDescriptor) {
        this.credentials = credentials;
        this.enableBranchAnalysis = svnConnectorDescriptor.branchingEnabled;
        this.branchesDirectory = svnConnectorDescriptor.branchesDirectory;
        this.pathSuffix = svnConnectorDescriptor.getPathSuffix();
        this.svnConnectorDescriptor = svnConnectorDescriptor;
    }

    @Override
    public Optional<CommitDescriptor> resolveToCommitDescriptor(String revision) {
        try {
            CommitDescriptor commitDescriptor = SVNUtils.determineCommitFromRevision(this.credentials, this.enableBranchAnalysis, this.branchesDirectory, this.pathSuffix, revision, this.svnConnectorDescriptor.getDefaultBranchName());
            return Optional.of(commitDescriptor);
        }
        catch (SVNException e) {
            LOGGER.warn("Could not resolve revision: " + revision, (Throwable)e);
            return Optional.empty();
        }
    }
}

