/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.svn.SvnChangeEntry;
import com.teamscale.index.repository.svn.SvnExternalTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableCollection;

public class SvnExternalsInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long NO_REVISION = 0L;
    private final Map<String, SvnExternalTarget> pathToTarget = new HashMap<String, SvnExternalTarget>();

    public SvnExternalsInfo() {
    }

    public SvnExternalsInfo(List<SvnExternalTarget> targets) {
        this.addTargets(targets);
    }

    public void addTarget(SvnExternalTarget target) {
        String localPath = target.getLocalPath();
        CCSMAssert.isFalse((boolean)this.pathToTarget.containsKey(localPath), (String)("Duplicate local path: " + localPath));
        this.pathToTarget.put(localPath, target);
    }

    public void addTargets(Collection<SvnExternalTarget> targets) {
        targets.forEach(this::addTarget);
    }

    public UnmodifiableCollection<SvnExternalTarget> getAll() {
        return CollectionUtils.asUnmodifiable(this.pathToTarget.values());
    }

    public ListMap<String, SvnExternalTarget> asRootRepoToTargetsWithoutFixedRevisions() {
        ListMap result = new ListMap();
        for (SvnExternalTarget target : this.pathToTarget.values()) {
            if (target.hasFixedRevision()) continue;
            result.add((Object)target.getRepositoryRoot(), (Object)target);
        }
        return result;
    }

    public List<String> getAllExternalWcPaths() {
        return new ArrayList<String>(this.pathToTarget.keySet());
    }

    public SvnExternalTarget getBestMatchingTarget(String wcPath) {
        String longestMatch = null;
        for (String path : this.pathToTarget.keySet()) {
            if (!wcPath.startsWith(path) || longestMatch != null && longestMatch.length() >= path.length()) continue;
            longestMatch = path;
        }
        CCSMAssert.isNotNull(longestMatch, (String)("Expected to find a longest match in any case for path " + wcPath));
        return this.pathToTarget.get(longestMatch);
    }

    public PairList<SvnExternalTarget, SvnExternalTarget> updateFromLogEntry(SvnChangeEntry entry) {
        PairList changes = new PairList();
        this.updateFromClearedPaths((PairList<SvnExternalTarget, SvnExternalTarget>)changes, entry.getClearedExternalPaths());
        for (SvnExternalTarget target : entry.getAddedExternalTargets()) {
            SvnExternalTarget existing;
            if (target.equals(existing = this.pathToTarget.put(target.getLocalPath(), target))) continue;
            changes.add((Object)existing, (Object)target);
            if (existing == null) continue;
            this.updateFromClearedPaths((PairList<SvnExternalTarget, SvnExternalTarget>)changes, CollectionUtils.filterToSet(this.pathToTarget.keySet(), key -> key.startsWith(target.getLocalPath() + "/")));
        }
        return changes;
    }

    private void updateFromClearedPaths(PairList<SvnExternalTarget, SvnExternalTarget> changes, Collection<String> clearedPaths) {
        for (String clearedPath : clearedPaths) {
            SvnExternalTarget oldValue = this.pathToTarget.remove(clearedPath);
            if (oldValue == null) continue;
            changes.add((Object)oldValue, null);
        }
    }
}

