/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.requirements_tracing.index.PolarionWorkItemLinkRoleIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.wia.SpecItem;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public class SpecItemDescriberInitializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();

    public static void initializeDescriber(IndexLayer indexLayer) {
        if (INITIALIZED.getAndSet(true)) {
            return;
        }
        try {
            SpecItemDescriberInitializer.importRolesFromConfiguredPolarionLinkRoles(indexLayer);
            SpecItemDescriberInitializer.importRolesFromSpecItems(indexLayer);
        }
        catch (StorageException e) {
            LOGGER.warn("Failed to initialize SpecItemDescriber. Spec Item Queries including relationships may fail until the next item with such a relationship is imported.", (Throwable)e);
        }
    }

    private static void importRolesFromConfiguredPolarionLinkRoles(IndexLayer indexLayer) throws StorageException {
        PolarionWorkItemLinkRoleIndex polarionCustomFieldIndex = (PolarionWorkItemLinkRoleIndex)indexLayer.openGlobalIndex(PolarionWorkItemLinkRoleIndex.class);
        Set<String> linkRoles = polarionCustomFieldIndex.getAllWorkItemLinkRoles();
        SpecItemHistoryIndex.DESCRIBER.addLinkRolesMapping(linkRoles);
    }

    private static void importRolesFromSpecItems(IndexLayer indexLayer) throws StorageException {
        List projects = indexLayer.openProjectIndex().getAllInternalProjectIds();
        for (InternalProjectId project : projects) {
            ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)project, (IndexLayer)indexLayer);
            for (String branch : SpecItemIndex.getRequirementManagementConnectorBranches(projectConfiguration)) {
                SpecItemIndex specItemIndex = (SpecItemIndex)indexLayer.openProjectIndex((IProjectId)project, SpecItemIndex.class, HistoryAccessOption.readHead((String)branch));
                Set<String> linkRoleNames = specItemIndex.getAllIssues().stream().map(SpecItem::getLinkRoles).flatMap(Collection::stream).collect(Collectors.toSet());
                SpecItemHistoryIndex.DESCRIBER.addLinkRolesMapping(linkRoleNames);
            }
        }
    }
}

