/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.cache;

import com.polarion.alm.ws.client.types.tracker.WorkItem;
import com.teamscale.index.requirements_tracing.index.SpecItemLatestRevisionCacheIndex;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;

public class PolarionLatestRevisionCacheSupport {
    private final SpecItemLatestRevisionCacheIndex specItemLatestRevisionCacheIndex;
    private final String connectorId;

    public PolarionLatestRevisionCacheSupport(SpecItemLatestRevisionCacheIndex specItemLatestRevisionCacheIndex, String connectorId) {
        this.specItemLatestRevisionCacheIndex = specItemLatestRevisionCacheIndex;
        this.connectorId = connectorId;
    }

    public Map<String, String> retrieveLatestKnownRevisions(List<WorkItem> workItems) throws StorageException {
        HashMap<String, String> latestKnownRevisionsById = new HashMap<String, String>();
        List<String> latestKnownRevisions = this.specItemLatestRevisionCacheIndex.getLastRevisions(workItems.stream().map(workItem -> this.computeInternalId(workItem.getId())).collect(Collectors.toList()));
        for (int i = 0; i < workItems.size(); ++i) {
            String latestKnownRevision = latestKnownRevisions.get(i);
            if (latestKnownRevision == null) continue;
            latestKnownRevisionsById.put(workItems.get(i).getId(), latestKnownRevision);
        }
        return latestKnownRevisionsById;
    }

    public void storeLatestKnownRevisions(Map<String, String> latestRevisionById) throws StorageException {
        Map<String, String> latestRevisionByInternalId = latestRevisionById.entrySet().stream().collect(Collectors.toMap(entry -> this.computeInternalId((String)entry.getKey()), Map.Entry::getValue));
        this.specItemLatestRevisionCacheIndex.storeLatestRevisions(latestRevisionByInternalId);
    }

    private String computeInternalId(String workItemId) {
        return TeamscaleIssueId.computeInternalId((String)this.connectorId, (String)workItemId);
    }
}

