/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.element_details.IncludePathDetail;
import com.teamscale.index.resource.element_details.IncludeSearchPathEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass(containedInBackup=true)
public class CompilationCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_COMPILER_COMMAND = "clang";
    private final IncludePathDetail includePathDetail;
    private final List<String> definitions;
    private final String compilerCommand;
    private final List<String> otherOptions;

    public CompilationCommand(IncludePathDetail includePathDetail, List<String> definitions, String compilerCommand, List<String> otherOptions) {
        this.includePathDetail = Objects.requireNonNull(includePathDetail);
        this.definitions = new ArrayList<String>(definitions);
        this.compilerCommand = Objects.requireNonNull(compilerCommand);
        this.otherOptions = Objects.requireNonNull(otherOptions);
    }

    @VisibleForTesting
    public CompilationCommand(IncludePathDetail includePathDetail, List<String> definitions) {
        this(includePathDetail, definitions, DEFAULT_COMPILER_COMMAND, Collections.emptyList());
    }

    public CompilationCommand(String compilerCommand) {
        this(new IncludePathDetail(), Collections.emptyList(), compilerCommand, Collections.emptyList());
    }

    public IncludePathDetail getIncludePathDetail() {
        return this.includePathDetail;
    }

    public List<String> getDefinitions() {
        return this.definitions;
    }

    public String getCompilerCommand() {
        return this.compilerCommand;
    }

    public List<String> getOtherOptions() {
        return this.otherOptions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Command: ");
        builder.append(this.compilerCommand);
        for (IncludeSearchPathEntry entry : this.includePathDetail.getIncludeSearchPathEntries()) {
            builder.append(" ");
            builder.append(entry.toString());
        }
        for (String definition : this.definitions) {
            builder.append(" ");
            builder.append(definition);
        }
        for (String option : this.otherOptions) {
            builder.append(" ");
            builder.append(option);
        }
        return builder.toString();
    }

    public static CompilationCommand getDefaultCompilationCommand() {
        return new CompilationCommand(DEFAULT_COMPILER_COMMAND);
    }
}

