/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.element_details.IECLanguageDetail;
import com.teamscale.index.resource.element_details.STFileType;
import com.teamscale.index.resource.element_details.VariableDeclarationDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class IEC61131ContentUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String VAR_FILE_NAME_PLC_NEXT_ENGINEER = "Variables.var";

    public static List<TokenElementDetailBase> getAndExtendIecDetails(String uniformPath, List<TokenElementDetailBase> details, List<ShallowEntity> entities, BasicTokenElementIndex basicTokenElementIndex) {
        ArrayList<TokenElementDetailBase> newDetails = new ArrayList<TokenElementDetailBase>(details);
        IECLanguageDetail languageDetail = IEC61131ContentUtils.getOrInsertDetail(newDetails, new IECLanguageDetail(CollectionUtils.asHashSet((Object[])new String[]{"ST"})));
        languageDetail.getLanguages().add("ST");
        if (CollectionUtils.anyMatch((Collection)ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.META), entity -> entity.getSubtype().equals("TYPE"))) {
            IEC61131ContentUtils.getOrInsertDetail(newDetails, STFileType.TYPES);
        } else {
            IEC61131ContentUtils.getOrInsertDetail(newDetails, STFileType.CODE);
        }
        VariableDeclarationDetail variableDeclarationDetail = IEC61131ContentUtils.getOrInsertDetail(newDetails, new VariableDeclarationDetail());
        IEC61131ContentUtils.addVariablesFromAST(variableDeclarationDetail, entities);
        IEC61131ContentUtils.addVariablesFromVarFile(variableDeclarationDetail, uniformPath, basicTokenElementIndex);
        return newDetails;
    }

    private static void addVariablesFromVarFile(VariableDeclarationDetail variableDeclarationDetail, String uniformPath, BasicTokenElementIndex basicTokenElementIndex) {
        BasicTokenElementInfo varFileElement;
        String expectedVarFilePath = FileSystemUtils.replaceFilePathFilenameWith((String)uniformPath, (String)VAR_FILE_NAME_PLC_NEXT_ENGINEER);
        try {
            varFileElement = basicTokenElementIndex.getTokenElement(expectedVarFilePath);
        }
        catch (StorageException e) {
            LOGGER.error("Storage Exception while accessing BasicTokenElementInfo of var file " + expectedVarFilePath, (Throwable)e);
            return;
        }
        if (varFileElement == null) {
            return;
        }
        List tokens = ScannerUtils.getTokens((String)varFileElement.getFilteredText(), (ELanguage)varFileElement.getLanguage(), (String)varFileElement.getUniformPath());
        try {
            List entities = ShallowParserFactory.createParser((ELanguage)varFileElement.getLanguage()).parseTopLevel(tokens);
            IEC61131ContentUtils.addVariablesFromAST(variableDeclarationDetail, entities);
        }
        catch (ShallowParserException e) {
            LOGGER.error("Could not parse " + expectedVarFilePath);
        }
    }

    private static <T extends TokenElementDetailBase> T getOrInsertDetail(List<TokenElementDetailBase> details, T newDetail) {
        Optional variableDeclarationDetail = BasicTokenElementInfo.getFirstDetailOfType(newDetail.getClass(), details);
        if (variableDeclarationDetail.isEmpty()) {
            details.add(newDetail);
            return newDetail;
        }
        return (T)((TokenElementDetailBase)variableDeclarationDetail.get());
    }

    public static void addVariablesFromAST(VariableDeclarationDetail variableDeclarationDetail, List<ShallowEntity> entities) {
        for (ShallowEntity metaEntity : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.META)) {
            switch (metaEntity.getSubtype()) {
                case "VAR": 
                case "VAR_ACCESS": 
                case "VAR_CONFIG": {
                    IEC61131ContentUtils.getVariablesAndTypes((UnmodifiableList<ShallowEntity>)metaEntity.getChildren()).forEach(variableDeclarationDetail::addLocalVariable);
                    break;
                }
                case "VAR_EXTERNAL": 
                case "VAR_GLOBAL": {
                    IEC61131ContentUtils.getVariablesAndTypes((UnmodifiableList<ShallowEntity>)metaEntity.getChildren()).forEach(variableDeclarationDetail::addExternalVariable);
                    break;
                }
                case "VAR_INPUT": 
                case "VAR_OUTPUT": 
                case "VAR_IN_OUT": {
                    IEC61131ContentUtils.getVariablesAndTypes((UnmodifiableList<ShallowEntity>)metaEntity.getChildren()).forEach(variableDeclarationDetail::addInputOrOutputVariable);
                    break;
                }
            }
        }
    }

    private static PairList<String, String> getVariablesAndTypes(UnmodifiableList<ShallowEntity> children) {
        PairList variablesAndTypes = new PairList();
        for (ShallowEntity variableDefinition : children) {
            int definitionTokensStart;
            if (variableDefinition.getType() != EShallowEntityType.ATTRIBUTE || !variableDefinition.getSubtype().equals("variable") || (definitionTokensStart = TokenStreamUtils.firstTokenOfTypeSequence((List)variableDefinition.includedTokens(), (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.IDENTIFIER})) == -1) continue;
            variablesAndTypes.add((Object)variableDefinition.getName(), (Object)((IToken)variableDefinition.includedTokens().get(definitionTokensStart + 2)).getText());
        }
        return variablesAndTypes;
    }

    private IEC61131ContentUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

