/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class TokenElementIndex
extends ProjectIndexWithDynamicNameBase {
    public static final String INDEX_NAME = "content";
    private final ValueIndex<TokenElementInfo> delegate;

    public TokenElementIndex(IStore store) {
        super(store);
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public static TokenElementIndex open(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        return (TokenElementIndex)projectStorageSystem.openProjectIndex(TokenElementIndex.class, INDEX_NAME, historyAccessOption);
    }

    public void setTokenElement(String uniformPath, TokenElementInfo tokenElementInfo) throws StorageException {
        CodeScopeDetail.verifyCodeScopeDetail(tokenElementInfo);
        this.delegate.setValue(uniformPath, (Object)tokenElementInfo);
    }

    public TokenElementInfo getTokenElement(String uniformPath) throws StorageException {
        return (TokenElementInfo)((Object)this.delegate.getValue(uniformPath));
    }

    public TokenElementInfo getTokenElement(UniformPath uniformPath) throws StorageException {
        return this.getTokenElement(uniformPath.toString());
    }

    public TokenElementInfo getTokenElementByPath(UniformPath uniformPath) throws StorageException {
        return (TokenElementInfo)((Object)this.delegate.getValue(uniformPath.toString()));
    }

    public List<TokenElementInfo> getTokenElements(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public List<TokenElementInfo> getTokenElementsForPaths(List<UniformPath> uniformPaths) throws StorageException {
        return this.getTokenElements(CollectionUtils.map(uniformPaths, UniformPath::toString));
    }

    public List<TokenElementInfo> getTokenElements(List<String> uniformPaths, boolean forceExistence) throws StorageException {
        return this.delegate.getValues(uniformPaths, forceExistence);
    }

    public List<String> getAllUniformPaths() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public List<String> getUniformPathsStartingWith(String pathPrefix) throws StorageException {
        return this.delegate.getKeysStartingWith(pathPrefix);
    }

    public Set<String> getContainedUniformPaths(List<String> uniformPaths) throws StorageException {
        return this.delegate.getContainedKeys(uniformPaths);
    }

    public void removeTokenElements(Collection<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }

    public void removeTokenElement(String uniformPath) throws StorageException {
        this.delegate.removeValue(uniformPath);
    }

    public void removeTokenElement(UniformPath uniformPath) throws StorageException {
        this.delegate.removeValue(uniformPath.toStringAsMigrationFrontier());
    }

    public void setTokenElements(PairList<String, TokenElementInfo> uniformPathsAndTokenElement) throws StorageException {
        for (TokenElementInfo tokenElementInfo : uniformPathsAndTokenElement.getSecondList()) {
            CodeScopeDetail.verifyCodeScopeDetail(tokenElementInfo);
        }
        this.delegate.setValues(uniformPathsAndTokenElement);
    }

    public PairList<String, TokenElementInfo> getAllTokenElements() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public PairList<String, TokenElementInfo> getEntriesByPathPrefix(String pathPrefix) throws StorageException {
        return this.delegate.getEntriesStartingWith(pathPrefix);
    }

    public PairList<String, TokenElementInfo> getEntriesByPathPrefix(List<String> pathPrefixes) throws StorageException {
        return this.delegate.getEntriesStartingWith(pathPrefixes);
    }

    public Map<String, TokenElementInfo> getTokenElementsByUniformPath(Collection<String> uniformPaths) throws StorageException {
        return this.delegate.getValuesByKeys(uniformPaths);
    }

    public void removeAllTokenElements() throws StorageException {
        this.delegate.removeAllEntries();
    }
}

