/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.reparsing_dependency;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.TestOnly;

public class IncludeRelations {
    private final Map<String, Integer> rootUniformPathPositions;
    private final Map<String, BitSet> includeRelations = new HashMap<String, BitSet>();

    IncludeRelations(List<String> rootUniformPaths) {
        this.rootUniformPathPositions = HashMap.newHashMap(rootUniformPaths.size());
        for (int i = 0; i < rootUniformPaths.size(); ++i) {
            this.rootUniformPathPositions.put(rootUniformPaths.get(i), i);
        }
    }

    public boolean propagateIncludeRelation(String includedUniformPath, String includingUniformPath) {
        boolean newInformationAdded;
        BitSet transitiveIncludesInIncludedFile = this.includeRelations.get(includedUniformPath);
        if (transitiveIncludesInIncludedFile == null) {
            return false;
        }
        BitSet transitiveIncludesInIncludingFile = this.includeRelations.get(includingUniformPath);
        if (transitiveIncludesInIncludingFile == null) {
            transitiveIncludesInIncludingFile = new BitSet(this.rootUniformPathPositions.size());
            this.includeRelations.put(includingUniformPath, transitiveIncludesInIncludingFile);
            newInformationAdded = true;
        } else {
            newInformationAdded = IncludeRelations.containsNewInformation(transitiveIncludesInIncludedFile, transitiveIncludesInIncludingFile);
        }
        transitiveIncludesInIncludingFile.or(transitiveIncludesInIncludedFile);
        return newInformationAdded;
    }

    public void setIncludes(String includedUniformPath, Collection<String> includingUniformPath) {
        Integer includedNameIndex = this.rootUniformPathPositions.get(includedUniformPath);
        for (String includingName : includingUniformPath) {
            this.includeRelations.computeIfAbsent(includingName, k -> new BitSet(this.rootUniformPathPositions.size())).set(includedNameIndex);
        }
    }

    private static boolean containsNewInformation(BitSet newBitSet, BitSet previousBitSet) {
        CCSMAssert.isTrue((newBitSet.size() == previousBitSet.size() ? 1 : 0) != 0, () -> "Bitsets must have the same size. Sizes were " + newBitSet.size() + " and " + previousBitSet.size() + " respectively.");
        for (int i = 0; i < previousBitSet.size(); ++i) {
            if (previousBitSet.get(i) || !newBitSet.get(i)) continue;
            return true;
        }
        return false;
    }

    @TestOnly
    public Map<String, BitSet> getIncludeRelations() {
        return this.includeRelations;
    }

    public Set<String> getIncludingUniformPaths() {
        return this.includeRelations.keySet();
    }

    public void remove(String includingUniformPath) {
        this.includeRelations.remove(includingUniformPath);
    }

    public void removeIf(Predicate<String> uniformPathPredicate) {
        this.includeRelations.keySet().removeIf(uniformPathPredicate);
    }

    public void removeAll(List<String> includingUniformPaths) {
        CollectionUtils.removeAll(this.includeRelations.keySet(), includingUniformPaths);
    }

    public Set<String> getPathsTransitivelyIncludingAnyOf(List<String> rootPathsSubset) {
        BitSet rootPathsSubsetTreeBitSet = new BitSet(this.rootUniformPathPositions.size());
        for (String rootPath : rootPathsSubset) {
            Integer position = this.rootUniformPathPositions.get(rootPath);
            if (position == null) {
                throw new IllegalArgumentException("Root path " + rootPath + " is not known!");
            }
            rootPathsSubsetTreeBitSet.set(position);
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, BitSet> entry : this.includeRelations.entrySet()) {
            String includingPath = entry.getKey();
            BitSet transitiveIncludes = entry.getValue();
            if (!transitiveIncludes.intersects(rootPathsSubsetTreeBitSet)) continue;
            result.add(includingPath);
        }
        return result;
    }
}

