/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.utils;

import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class DiffUtils {
    private static final int MAX_DELTA_SIZE = 10000;

    public static boolean isChanged(TextRegionLocation newRegion, TokenElementInfo oldElement, TokenElementInfo newElement) throws DiffComputationException {
        return DiffUtils.isChanged(newRegion, oldElement, newElement, null);
    }

    public static boolean isChanged(TextRegionLocation newRegion, TokenElementInfo oldElement, TokenElementInfo newElement, Predicate<IToken> tokenFilter) throws DiffComputationException {
        List<IToken> newTokens;
        if (oldElement.getLanguage() != newElement.getLanguage()) {
            throw new DiffComputationLanguageException(String.format("Teamscale now interprets the language of the new file %s as %s and not as %s, as it did previously with %s.", newElement.getUniformPath(), newElement.getLanguage(), oldElement.getLanguage(), oldElement.getUniformPath()));
        }
        if (newElement.getText().length() <= newRegion.getRawEndOffset()) {
            throw new DiffComputationException(String.format("Region end offset %s is outside of text length %s for file %s", newRegion.getRawEndOffset(), newElement.getText().length(), newElement.getUniformPath()));
        }
        List<IToken> oldTokens = DiffUtils.determineTokens(oldElement, tokenFilter);
        Diff.Delta delta = Diff.computeDelta(oldTokens, newTokens = DiffUtils.determineTokens(newElement, tokenFilter), (int)10000, (token1, token2) -> token1.getText().equals(token2.getText()));
        if (delta.getSize() >= 10000) {
            return true;
        }
        return DiffUtils.deltaAffectsNewRegion((Diff.Delta<IToken>)delta, newRegion, newTokens);
    }

    private static boolean deltaAffectsNewRegion(Diff.Delta<IToken> delta, TextRegionLocation newRegion, List<IToken> newTokens) {
        int oldIndex = 0;
        int newIndex = 0;
        for (int i = 0; i < delta.getSize(); ++i) {
            int position = delta.getPosition(i);
            if (position > 0) {
                oldIndex += --position - newIndex;
                newIndex = position + 1;
                if (!DiffUtils.isContained(newRegion, newTokens.get(position).getOffset())) continue;
                return true;
            }
            oldIndex = position + 1;
            if ((newIndex += (position = -position - 1) - oldIndex) >= newTokens.size()) continue;
            int offset = newTokens.get(newIndex).getOffset();
            if (newIndex > 0) {
                offset = (offset + newTokens.get(newIndex - 1).getEndOffset()) / 2;
            }
            if (!DiffUtils.isContained(newRegion, offset)) continue;
            return true;
        }
        return false;
    }

    private static boolean isContained(TextRegionLocation region, int offset) {
        return region.getRawStartOffset() <= offset && offset <= region.getRawEndOffset();
    }

    private static List<IToken> determineTokens(TokenElementInfo element, Predicate<IToken> tokenFilter) {
        List tokens = ScannerUtils.getTokens((String)element.getText(), (ELanguage)element.getLanguage(), (String)element.getUniformPath());
        if (tokenFilter != null) {
            tokens = CollectionUtils.filter((Collection)tokens, tokenFilter);
        }
        return tokens;
    }

    private DiffUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static class DiffComputationLanguageException
    extends DiffComputationException {
        private static final long serialVersionUID = 1L;

        private DiffComputationLanguageException(String message) {
            super(message);
        }
    }

    public static class DiffComputationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private DiffComputationException(String message) {
            super(message);
        }
    }
}

