/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageLookup;
import jakarta.ws.rs.NotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class S3ProjectConfigurationUtils {
    public static List<ConnectorConfiguration> getS3Connectors(ProjectConfiguration projectConfig) {
        return CollectionUtils.filter((Collection)projectConfig.getConnectors(), connector -> connector.isRepositoryType(ERepositoryConnector.S3));
    }

    public static boolean hasS3StorageBackend(ProjectConfiguration projectConfig, ExternalStorageBackendIndex externalStorageBackendIndex) throws StorageException {
        if (projectConfig.getExternalStorageBackend() == null) {
            return false;
        }
        Optional<ExternalStorageBackend> externalStorageBackend = ExternalStorageLookup.getStorageBackend(projectConfig, externalStorageBackendIndex);
        if (externalStorageBackend.isEmpty()) {
            throw new NotFoundException("External storage '%s' selected in project %s not found.".formatted(projectConfig.getExternalStorageBackend(), projectConfig.getPrimaryPublicId()));
        }
        return externalStorageBackend.get().backendProtocol() == EExternalStorageBackendProtocol.S3;
    }

    private S3ProjectConfigurationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

