/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.search;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.search.CodeSearchIndex;
import com.teamscale.index.search.InvertedCodeSearchIndex;
import com.teamscale.index.search.SearchSource;
import com.teamscale.index.search.SearchToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CodeSearchIndexInverter
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CodeSearchIndex codeSearchIndex;
    @DeltaSource(value=CodeSearchIndex.class)
    private KeyDelta codeSearchDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private InvertedCodeSearchIndex invertedCodeSearchIndex;

    public void execute() throws StorageException {
        HashSet<SearchSource> changedSources = new HashSet<SearchSource>(this.codeSearchIndex.parseKeys((List<StorageKey>)this.codeSearchDelta.getAddedOrChangedKeys()));
        List<SearchToken> newTokens = this.codeSearchIndex.getTokensBySource(changedSources);
        changedSources.addAll(this.codeSearchIndex.parseKeys((List<StorageKey>)this.codeSearchDelta.getDeletedKeys()));
        List<SearchToken> oldTokens = this.invertedCodeSearchIndex.getOldTokensBySource(changedSources);
        HashSet<String> affectedTokens = new HashSet<String>();
        ListMap newTokensByText = new ListMap();
        for (SearchToken token : oldTokens) {
            affectedTokens.add(token.getText().toLowerCase());
        }
        for (SearchToken token : newTokens) {
            String lowerCaseText = token.getText().toLowerCase();
            affectedTokens.add(lowerCaseText);
            newTokensByText.add((Object)lowerCaseText, (Object)token);
        }
        ArrayList tokenTexts = CollectionUtils.sort(affectedTokens);
        List<List<SearchToken>> invertedTokensByText = this.determineUpdatedInvertedTokens((ListMap<String, SearchToken>)newTokensByText, changedSources, tokenTexts);
        this.invertedCodeSearchIndex.updateOldTokens(this.codeSearchIndex, this.codeSearchDelta);
        this.invertedCodeSearchIndex.updateInvertedTokens(tokenTexts, invertedTokensByText);
    }

    private List<List<SearchToken>> determineUpdatedInvertedTokens(ListMap<String, SearchToken> newTokensByText, Set<SearchSource> changedSources, List<String> tokenTexts) throws StorageException {
        List<List<SearchToken>> invertedTokensByText = this.invertedCodeSearchIndex.getTokensByText(tokenTexts);
        for (int i = 0; i < tokenTexts.size(); ++i) {
            List<SearchToken> list = invertedTokensByText.get(i);
            list.removeIf(token -> changedSources.contains(token.getSearchSource()));
            String text = tokenTexts.get(i);
            if (!newTokensByText.containsCollection((Object)text)) continue;
            list.addAll(newTokensByText.getCollection((Object)text));
        }
        return invertedTokensByText;
    }
}

