/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.metric;

import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysis;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysisBase;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@SimulinkMetricAnalysis(name="Model Nesting Depth", description="Calculates the subsystem nesting depth in a model.", internalName="#nesting", metricProperties={}, aggregation=MetricDirectorySchemaEntry.EAggregation.MAX, qualityIndicator="Structure")
public class NestingDepthMetric
extends SimulinkMetricAnalysisBase {
    private static final Comparator<SimulinkBlock> BY_LEVEL_COMPARATOR = Comparator.comparingInt(NestingDepthMetric::getLevel);

    @Override
    public Double calculateMetricValue(SimulinkModel model) {
        return NestingDepthMetric.calculateSubsystemDepth((SimulinkBlock)model);
    }

    public static int calculateSubsystemDepth(SimulinkBlock block) {
        SimulinkBlock deepestSubsystem = NestingDepthMetric.getDeepestSubsystem(block).orElse(block);
        return NestingDepthMetric.getLevel(deepestSubsystem) - NestingDepthMetric.getLevel(block);
    }

    public static Optional<SimulinkBlock> getDeepestSubsystem(SimulinkBlock block) {
        List subsystems = SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)block, Collections.singleton("SubSystem"), (boolean)false, (boolean)false);
        return subsystems.stream().max(BY_LEVEL_COMPARATOR);
    }

    public static int getLevel(SimulinkBlock block) {
        if (block.getParent() == null) {
            return 0;
        }
        if (!SimulinkUtils.isUserVisible((SimulinkBlock)block)) {
            return NestingDepthMetric.getLevel(block.getParent());
        }
        return 1 + NestingDepthMetric.getLevel(block.getParent());
    }
}

