/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="simulink.opaque-libraries", name="Opaque Libraries", type=EOptionType.PROJECT, category=EOptionCategory.SIMULINK, orderingHint=500)
@IndexValueClass(containedInBackup=true)
public class SimulinkOpaqueLibrariesOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "simulink.opaque-libraries";
    public static final String OPTION_NAME = "Opaque Libraries";
    @JsonProperty(value="opaqueLibrariesPattern")
    @OptionFieldDescription(name="Regex pattern for libraries that are treated like basic blocks")
    public String opaqueLibrariesPattern = "";

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (!StringUtils.isEmpty((String)this.opaqueLibrariesPattern)) {
            try {
                Pattern.compile(this.opaqueLibrariesPattern);
            }
            catch (PatternSyntaxException e) {
                return "Invalid pattern: " + this.opaqueLibrariesPattern + ". " + e.getMessage();
            }
        }
        return null;
    }

    public Predicate<String> getOpaqueLibrariesPatternAsPredicate() throws StorageException {
        if (StringUtils.isEmpty((String)this.opaqueLibrariesPattern)) {
            return x -> false;
        }
        try {
            Pattern pattern = Pattern.compile(this.opaqueLibrariesPattern);
            return string -> pattern.matcher((CharSequence)string).matches();
        }
        catch (PatternSyntaxException e) {
            throw new StorageException("Invalid pattern: " + this.opaqueLibrariesPattern + ". " + e.getMessage(), (Throwable)e);
        }
    }

    public static SimulinkOpaqueLibrariesOption loadFromIndex(ProjectOptionIndex projectOptionIndex) throws StorageException {
        SimulinkOpaqueLibrariesOption option = (SimulinkOpaqueLibrariesOption)ProjectOptionRegistry.getInstance().getOption("<p>", OPTION_ID, null, SimulinkOpaqueLibrariesOption.class, (OptionIndexBase)projectOptionIndex);
        if (option == null) {
            return new SimulinkOpaqueLibrariesOption();
        }
        return option;
    }
}

