/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;

public class SimulinkLibraryLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SimulinkModelInfoIndex simulinkModelInfoIndex;
    private final LazyModelLoader modelLoader;
    private final Set<String> alreadyLoggedMissingLibraries = new HashSet<String>();
    private final Set<String> alreadyLoggedNotDefinitiveLibraries = new HashSet<String>();

    public SimulinkLibraryLoader(LazyModelLoader lazyModelLoader, SimulinkModelInfoIndex index) {
        this.simulinkModelInfoIndex = index;
        this.modelLoader = lazyModelLoader;
    }

    public List<SimulinkModel> loadLibraryFromReferenceBlock(SimulinkBlock block) throws StorageException {
        String blockId = block.getParameter("SourceBlock");
        ArrayList<SimulinkModel> models = new ArrayList<SimulinkModel>();
        if (blockId == null) {
            return models;
        }
        List<String> uniformPaths = this.simulinkModelInfoIndex.getUniformPathsForBlockId(blockId);
        for (String uniformPath : uniformPaths) {
            this.modelLoader.getModelByUniformPath(uniformPath).ifPresent(models::add);
        }
        this.logWarningsIfNecessary(block, models.size());
        return models;
    }

    private void logWarningsIfNecessary(SimulinkBlock block, int numberOfLoadedModels) {
        String modelPath = block.getModel().getUniformPath();
        if (numberOfLoadedModels == 0 && this.alreadyLoggedMissingLibraries.add(modelPath)) {
            LOGGER.warn(String.format("Referenced Simulink Library for block %s could not be found for Simulink model %s. The extracted information may be incomplete.", block, modelPath));
        } else if (numberOfLoadedModels > 1 && this.alreadyLoggedNotDefinitiveLibraries.add(modelPath)) {
            LOGGER.warn(String.format("Referenced Simulink Library for block %s could not be determined definitively for Simulink model %s since multiple libraries provide the used block id. This could lead to falsely propagated information.", block, modelPath));
        }
    }

    public List<SimulinkModel> loadReferencedModelFromSubsystemReferenceBlock(SimulinkBlock block) throws StorageException {
        String referencedModelSimpleFileName = block.getParameter("ReferencedSubsystem");
        if (referencedModelSimpleFileName == null) {
            return Collections.emptyList();
        }
        ArrayList<SimulinkModel> models = new ArrayList<SimulinkModel>();
        List<String> uniformPaths = this.simulinkModelInfoIndex.getUniformPathsWithSimpleFileName(referencedModelSimpleFileName);
        for (String uniformPath : uniformPaths) {
            this.modelLoader.getModelByUniformPath(uniformPath).ifPresent(models::add);
        }
        this.logWarningsIfNecessary(block, models.size());
        return models;
    }
}

