/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.simulink.tracing.DerivedFindingsIndexSynchronizerBase;
import com.teamscale.index.simulink.tracing.SimulinkCoderGeneratorTracingUtils;
import com.teamscale.index.simulink.tracing.SimulinkPlcCoderTraceIndex;
import com.teamscale.index.simulink.tracing.SimulinkSourceFileMapper;
import com.teamscale.index.simulink.tracing.TracelinkAbbreviationIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class SimulinkGeneratedCodeFindingsSynchronizer
extends DerivedFindingsIndexSynchronizerBase {
    public static final String SIMULINK_GENERATED_CODE_PARTITION = "simulink-generated-code";
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TracelinkAbbreviationIndex tracelinkAbbreviationIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkPlcCoderTraceIndex plcCoderTraceIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkModelInfoIndex modelInfoIndex;

    @Override
    protected void deriveFindings(TokenElementInfo sourceElement, ListMap<String, IndexFinding> partitionToFindings) throws StorageException {
        ElementLocation defaultSimulinkLocation = null;
        if (sourceElement.getLanguage() != ELanguage.IEC61131) {
            Optional<Pair<String, String>> modelNameAndPath = this.getModelNameAndPath(sourceElement);
            if (!modelNameAndPath.isPresent()) {
                return;
            }
            defaultSimulinkLocation = new ElementLocation((String)modelNameAndPath.get().getSecond());
        }
        SimulinkSourceFileMapper mapper = new SimulinkSourceFileMapper(sourceElement, this.modelInfoIndex, this.tracelinkAbbreviationIndex, this.plcCoderTraceIndex, defaultSimulinkLocation);
        for (String partition : partitionToFindings.getKeys()) {
            for (IndexFinding finding : (List)partitionToFindings.getCollection((Object)partition)) {
                int line = 0;
                if (finding.getLocation() instanceof TextRegionLocation) {
                    line = ((TextRegionLocation)finding.getLocation()).getRawStartLine();
                }
                this.reportDerivedFinding(finding, mapper.resolveSimulinkLocationsForLine(line), partition);
            }
        }
    }

    private Optional<Pair<String, String>> getModelNameAndPath(TokenElementInfo codeElement) throws StorageException {
        Optional<String> modelName = SimulinkCoderGeneratorTracingUtils.extractModelName(codeElement);
        if (!modelName.isPresent()) {
            return Optional.empty();
        }
        return this.modelInfoIndex.getUniqueUniformPathForModelName(modelName.get()).map(path -> new Pair((Object)((String)modelName.get()), path));
    }

    @Override
    protected boolean isPotentialSourceFile(TokenElementInfo element) {
        return SimulinkSourceFileMapper.fileMayBeGeneratedFromSimulinkModel(element);
    }

    @Override
    protected String getPartition() {
        return SIMULINK_GENERATED_CODE_PARTITION;
    }

    @Override
    protected List<String> determineTargetElementPaths(TokenElementInfo sourceElement) throws StorageException {
        if (sourceElement.getLanguage() == ELanguage.IEC61131) {
            SimulinkSourceFileMapper mapper = new SimulinkSourceFileMapper(sourceElement, this.modelInfoIndex, this.tracelinkAbbreviationIndex, this.plcCoderTraceIndex, null);
            return mapper.getAllReferencedSimulinkUniformPaths();
        }
        Optional<Pair<String, String>> nameAndPath = this.getModelNameAndPath(sourceElement);
        if (!nameAndPath.isPresent()) {
            return Collections.emptyList();
        }
        SimulinkSourceFileMapper mapper = new SimulinkSourceFileMapper(sourceElement, this.modelInfoIndex, this.tracelinkAbbreviationIndex, this.plcCoderTraceIndex, new ElementLocation((String)nameAndPath.get().getSecond()));
        return mapper.getAllReferencedSimulinkUniformPaths();
    }
}

