/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.component;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.stacktrace.component.IStacktraceComponent;
import com.teamscale.index.stacktrace.component.StackFrame;
import com.teamscale.index.stacktrace.visitor.IStacktraceVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class ExceptionRepresentation
implements IStacktraceComponent {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="message")
    protected @Nullable String message;
    @JsonProperty(value="threadName")
    protected @Nullable String threadName;
    @JsonProperty(value="stackFrames")
    protected List<StackFrame> stackFrames;
    @JsonProperty(value="skippedStackFrames")
    protected int skippedStackFrames;
    @JsonProperty(value="isCauseException")
    protected boolean isCauseException;

    @Override
    public void add(StackFrame component) {
        this.stackFrames.add(component);
    }

    private ExceptionRepresentation() {
        this("", "", null, false);
    }

    private ExceptionRepresentation(String name, String message, String threadName, boolean isCauseException) {
        this.name = name;
        this.message = message;
        this.threadName = threadName;
        this.stackFrames = new ArrayList<StackFrame>();
        this.skippedStackFrames = 0;
        this.isCauseException = isCauseException;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<StackFrame> getStackFrames() {
        return this.stackFrames;
    }

    public void setStackFrames(List<StackFrame> stackFrames) {
        this.stackFrames = stackFrames;
    }

    public int getSkippedStackFrames() {
        return this.skippedStackFrames;
    }

    public void setSkippedStackFrames(int skippedStackFrames) {
        this.skippedStackFrames = skippedStackFrames;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public boolean isCauseException() {
        return this.isCauseException;
    }

    public void setCauseException(boolean isCauseException) {
        this.isCauseException = isCauseException;
    }

    @Override
    public String getStringRepresentation(int nestingLevel) {
        String indentation = StringUtils.fillString((int)nestingLevel, (char)'\t');
        StringBuilder stringBuilder = new StringBuilder();
        String exceptionTypeName = "InitialException";
        if (this.isCauseException) {
            exceptionTypeName = "CauseException";
        }
        stringBuilder.append(indentation + "[" + exceptionTypeName);
        if (!this.isCauseException && this.threadName != null) {
            stringBuilder.append(" threadName=\"" + this.threadName + "\"");
        }
        stringBuilder.append(" name=\"" + this.name + "\"");
        if (this.message != null) {
            stringBuilder.append(" message=\"" + this.message + "\"");
        }
        stringBuilder.append("]" + StringUtils.LINE_SEPARATOR);
        for (StackFrame stackFrame : this.stackFrames) {
            stringBuilder.append(stackFrame.getStringRepresentation(nestingLevel + 1));
        }
        if (this.skippedStackFrames > 0) {
            stringBuilder.append(indentation + "\t[" + this.skippedStackFrames + " more]" + StringUtils.LINE_SEPARATOR);
        }
        stringBuilder.append(indentation + "[/" + exceptionTypeName + "]" + StringUtils.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    public static ExceptionRepresentation newInitialException(String name, String message, String threadName) {
        return new ExceptionRepresentation(name, message, threadName, false);
    }

    public static ExceptionRepresentation newCauseException(String name, String message) {
        return new ExceptionRepresentation(name, message, null, true);
    }

    public String toString() {
        return this.getStringRepresentation(0);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.message, this.threadName, this.stackFrames, this.skippedStackFrames, this.isCauseException);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionRepresentation other = (ExceptionRepresentation)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.message, other.message) && Objects.equals(this.threadName, other.threadName) && Objects.equals(this.stackFrames, other.stackFrames) && Objects.equals(this.skippedStackFrames, other.skippedStackFrames) && Objects.equals(this.isCauseException, other.isCauseException);
    }

    @Override
    public void accept(IStacktraceVisitor stacktraceVisitor) {
        stacktraceVisitor.visit(this);
    }
}

