/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.component;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.stacktrace.component.ExceptionRepresentation;
import com.teamscale.index.stacktrace.component.IStacktraceComponent;
import com.teamscale.index.stacktrace.visitor.IStacktraceVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class Stacktrace
implements IStacktraceComponent {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="initialException")
    private ExceptionRepresentation initialException = null;
    @JsonProperty(value="causeExceptions")
    private List<ExceptionRepresentation> causeExceptions = new ArrayList<ExceptionRepresentation>();

    @Override
    public void add(ExceptionRepresentation component) {
        if (!component.isCauseException) {
            if (this.initialException != null) {
                throw new IllegalStateException("Could not add initial exception, this stacktrace already has one.");
            }
            this.initialException = component;
        } else {
            this.causeExceptions.add(component);
        }
    }

    public ExceptionRepresentation getLastException() {
        if (this.causeExceptions.isEmpty()) {
            return this.initialException;
        }
        return (ExceptionRepresentation)CollectionUtils.getLast(this.causeExceptions);
    }

    @Override
    public String getStringRepresentation(int nestingLevel) {
        String indentation = StringUtils.fillString((int)nestingLevel, (char)'\t');
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(indentation + "[Stacktrace]" + StringUtils.LINE_SEPARATOR);
        stringBuilder.append(this.initialException.getStringRepresentation(nestingLevel + 1));
        for (ExceptionRepresentation causeException : this.causeExceptions) {
            stringBuilder.append(causeException.getStringRepresentation(nestingLevel + 1));
        }
        stringBuilder.append(indentation + "[/Stacktrace]");
        return stringBuilder.toString();
    }

    public ExceptionRepresentation getInitialException() {
        return this.initialException;
    }

    public void setInitialException(ExceptionRepresentation initialException) {
        this.initialException = initialException;
    }

    public List<ExceptionRepresentation> getCauseExceptions() {
        return this.causeExceptions;
    }

    public void setCauseExceptions(List<ExceptionRepresentation> causeExceptions) {
        this.causeExceptions = causeExceptions;
    }

    public int hashCode() {
        return Objects.hash(this.initialException, this.causeExceptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Stacktrace other = (Stacktrace)o;
        return Objects.equals(this.initialException, other.initialException) && Objects.equals(this.causeExceptions, other.causeExceptions);
    }

    public String toString() {
        return this.getStringRepresentation(0);
    }

    @Override
    public void accept(IStacktraceVisitor stacktraceVisitor) {
        stacktraceVisitor.visit(this);
    }
}

