/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.structure;

import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.structure.NumericMetricAnalyzerBase;
import com.teamscale.wia.WiaUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class LOCAnalyzer
extends NumericMetricAnalyzerBase {
    private static final String METRIC_NAME = "LoC";
    private final LazyModelLoader modelLoader;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean IS_PRE_JAVA_16_LINE_NUMBER_READER = Runtime.version().feature() < 16;

    public LOCAnalyzer(BinaryElementIndex binaryElementIndex) {
        this.modelLoader = new LazyModelLoader(binaryElementIndex);
    }

    @Override
    protected String getMetricName() {
        return METRIC_NAME;
    }

    @Override
    protected String getValueFindingProperty() {
        return "Lines";
    }

    @Override
    protected void calculateMetrics(TokenElementInfo element) {
        if (LOCAnalyzer.isSkipped(element)) {
            return;
        }
        try {
            this.reportMetricValue(this.countLoc(element));
        }
        catch (ConQATException e) {
            LOGGER.error("Error counting LOC for " + String.valueOf((Object)element) + ": " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    static boolean isSkipped(TokenElementInfo element) {
        if (element.getLanguage() == ELanguage.ABAP_DDIC) {
            return true;
        }
        if (WiaUtils.isWiaEnabledLanguage((ELanguage)element.getLanguage())) {
            return true;
        }
        if (element.getLanguage() == ELanguage.TEXT) {
            String uniformPath = element.getUniformPath();
            return UniformPathUtils.isArchitectureFile((String)uniformPath);
        }
        return false;
    }

    private int countLoc(TokenElementInfo element) throws ConQATException {
        if (element.getLanguage() == ELanguage.SIMULINK && SimulinkUtils.isSimulinkModelPath((String)element.getUniformPath())) {
            try {
                Optional<SimulinkModel> model = this.modelLoader.getModelByUniformPath(element.getUniformPath());
                if (model.isPresent()) {
                    return SimulinkUtils.getBlockCount((SimulinkBlock)((SimulinkBlock)model.get()));
                }
                throw new ConQATException("Model not found: " + element.getUniformPath());
            }
            catch (StorageException e) {
                throw new ConQATException("Error loading model " + element.getUniformPath() + ":" + String.valueOf((Object)e), (Throwable)e);
            }
        }
        return LOCAnalyzer.countLoc(element.getFilteredText());
    }

    private static int countLoc(String code) {
        int n;
        BufferedReader reader = new BufferedReader(new StringReader(code));
        try {
            n = LOCAnalyzer.countLoc(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError("Impossible with StringReader", e);
            }
        }
        reader.close();
        return n;
    }

    public static int countLoc(BufferedReader reader) throws IOException {
        try (LineNumberReader lineNumberReader = new LineNumberReader(reader);){
            int n;
            int readChars;
            boolean lastCharWasEndOfLine = false;
            boolean isEmpty = true;
            char[] buffer = new char[8192];
            while ((readChars = lineNumberReader.read(buffer)) != -1) {
                if (readChars <= 0) continue;
                isEmpty = false;
                char lastChar = buffer[readChars - 1];
                lastCharWasEndOfLine = lastChar == '\r' || lastChar == '\n';
            }
            if (!isEmpty && (IS_PRE_JAVA_16_LINE_NUMBER_READER || lastCharWasEndOfLine)) {
                n = lineNumberReader.getLineNumber() + 1;
                return n;
            }
            n = lineNumberReader.getLineNumber();
            return n;
        }
    }
}

