/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.structure;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.structure.NumericMetricAnalyzerBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public abstract class LongestStatementListAnalyzerBase
extends NumericMetricAnalyzerBase {
    private static final String METRIC_NAME = "LSL";
    protected final boolean slocBased;

    protected LongestStatementListAnalyzerBase(boolean slocBased) {
        this.slocBased = slocBased;
    }

    @Override
    protected String getMetricName() {
        return METRIC_NAME;
    }

    @Override
    protected void calculateMetrics(TokenElementInfo element) throws StorageException {
        HashSet<Integer> ignoredLines = new HashSet<Integer>();
        if (this.slocBased) {
            ignoredLines.addAll(LongestStatementListAnalyzerBase.determineEmptyLines(element));
            ignoredLines.addAll(LongestStatementListAnalyzerBase.determineCommentLines(element));
        }
        this.calculateStatementListLocations(element, ignoredLines);
    }

    private static Set<Integer> determineEmptyLines(TokenElementInfo element) {
        HashSet<Integer> emptyLines = new HashSet<Integer>();
        int lineNumber = 1;
        for (String line : StringUtils.splitLines((String)element.getFilteredText())) {
            if (StringUtils.isEmpty((String)line)) {
                emptyLines.add(lineNumber);
            }
            ++lineNumber;
        }
        return emptyLines;
    }

    private static Set<Integer> determineCommentLines(TokenElementInfo element) {
        HashSet<Integer> nonCommentLines = new HashSet<Integer>();
        HashSet<Integer> commentLines = new HashSet<Integer>();
        for (IToken token : element.getTokens()) {
            if (token.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT) {
                LongestStatementListAnalyzerBase.insertTokenLines(commentLines, token);
                continue;
            }
            if (token.getType().getTokenClass() == ETokenType.ETokenClass.WHITESPACE) continue;
            LongestStatementListAnalyzerBase.insertTokenLines(nonCommentLines, token);
        }
        commentLines.removeAll(nonCommentLines);
        return commentLines;
    }

    private static void insertTokenLines(Set<Integer> lines, IToken token) {
        int startLine = token.getLineNumber();
        int length = StringUtils.splitLinesAsList((String)token.getText()).size();
        for (int i = 0; i < length; ++i) {
            lines.add(startLine + 1 + i);
        }
    }

    protected abstract void calculateStatementListLocations(TokenElementInfo var1, Set<Integer> var2) throws StorageException;

    protected void reportStatementListForOffsets(int startOffset, int endOffset, Set<Integer> ignoredLines) {
        int startLine = this.currentLineOffsetConverter.getLine(startOffset);
        int endLine = this.currentLineOffsetConverter.getLine(endOffset);
        int length = LongestStatementListAnalyzerBase.computeLength(startLine, endLine, ignoredLines);
        int rawStartOffset = this.currentOffsetTransformer.getUnfilteredOffset(startOffset);
        int rawEndOffset = this.currentOffsetTransformer.getUnfilteredOffset(endOffset);
        int rawStartLine = this.currentRawLineOffsetConverter.getLine(rawStartOffset);
        int rawEndLine = this.currentRawLineOffsetConverter.getLine(rawEndOffset);
        this.reportMetricValue(length, (ElementLocation)new TextRegionLocation(this.currentElement.getUniformPath(), rawStartOffset, rawEndOffset, rawStartLine, rawEndLine));
    }

    private static int computeLength(int startLine, int endLine, Set<Integer> ignoredLines) {
        int length = 0;
        for (int line = startLine; line <= endLine; ++line) {
            if (ignoredLines.contains(line)) continue;
            ++length;
        }
        return length;
    }
}

