/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.structure;

import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.IToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.LineOffsetConverter;

public abstract class NumericMetricAnalyzerBase {
    private final List<ThresholdInfo> thresholds = new ArrayList<ThresholdInfo>();
    private boolean hadValue = false;
    private double currentAggregate = 0.0;
    protected TokenElementInfo currentElement;
    protected StringOffsetTransformer currentOffsetTransformer;
    protected LineOffsetConverter currentRawLineOffsetConverter;
    protected LineOffsetConverter currentLineOffsetConverter;
    private final PairList<String, Serializable> metricValues = new PairList();
    private final ListMap<String, IndexFinding> findings = new ListMap();
    private static final Logger LOGGER = LogManager.getLogger();

    public void setFindingThreshold(int threshold, ETrafficLightColor color) {
        this.setFindingThreshold(threshold, color, this.getMetricName());
    }

    public void setFindingThreshold(int threshold, ETrafficLightColor color, String messageCore) {
        this.thresholds.add(new ThresholdInfo(threshold, color, messageCore));
    }

    private void analyzeElement(TokenElementInfo element) {
        this.hadValue = false;
        this.currentElement = element;
        this.currentOffsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
        this.currentRawLineOffsetConverter = new LineOffsetConverter(element.getText());
        this.currentLineOffsetConverter = new LineOffsetConverter(element.getFilteredText());
        this.currentAggregate = 0.0;
        try {
            this.calculateMetrics(element);
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to calculate numeric metrics for element: " + element.getUniformPath(), throwable);
        }
        this.metricValues.add((Object)element.getUniformPath(), (Object)this.currentAggregate);
    }

    public void analyze(Collection<TokenElementInfo> elements) {
        for (TokenElementInfo element : elements) {
            this.analyzeElement(element);
        }
    }

    public PairList<String, Serializable> getMetricValues() {
        return this.metricValues;
    }

    public ListMap<String, IndexFinding> getFindings() {
        return this.findings;
    }

    protected abstract void calculateMetrics(TokenElementInfo var1) throws StorageException;

    protected final void reportMetricValue(int value, ElementLocation location) {
        this.aggregate(value);
        for (ThresholdInfo threshold : this.thresholds) {
            if (!threshold.isViolation(value)) continue;
            IndexFinding finding = new IndexFinding(this.getMetricName(), "Metric Violations", threshold.formatMessage(value), location);
            finding.setAssessment(threshold.color);
            finding.setProperty(this.getValueFindingProperty(), (Object)value);
            this.findings.add((Object)location.getUniformPath(), (Object)finding);
            break;
        }
    }

    protected abstract String getValueFindingProperty();

    protected static String getFindingTypeId(String metricName) {
        return IndexFinding.makeFindingTypeId((String)"Metric Violations", (String)metricName);
    }

    private void aggregate(double value) {
        if (this.hadValue) {
            this.currentAggregate = this.aggregateMax() ? Math.max(value, this.currentAggregate) : Math.min(value, this.currentAggregate);
        } else {
            this.hadValue = true;
            this.currentAggregate = value;
        }
    }

    protected void reportMetricValue(int value) {
        this.reportMetricValue(value, new ElementLocation(this.currentElement.getUniformPath()));
    }

    protected boolean aggregateMax() {
        return true;
    }

    protected abstract String getMetricName();

    protected void reportMetricValueForFilteredTokenRegion(int value, IToken firstToken, IToken lastToken) {
        int rawStartOffset = this.currentOffsetTransformer.getUnfilteredOffset(firstToken.getOffset());
        int rawEndOffset = this.currentOffsetTransformer.getUnfilteredOffset(lastToken.getEndOffset());
        int rawStartLine = this.currentRawLineOffsetConverter.getLine(rawStartOffset);
        int rawEndLine = this.currentRawLineOffsetConverter.getLine(rawEndOffset);
        TextRegionLocation location = new TextRegionLocation(this.currentElement.getUniformPath(), rawStartOffset, rawEndOffset, rawStartLine, rawEndLine);
        this.reportMetricValue(value, (ElementLocation)location);
    }

    private class ThresholdInfo {
        private final int threshold;
        private final ETrafficLightColor color;
        private final String messageCore;

        public ThresholdInfo(int threshold, ETrafficLightColor color, String messageCore) {
            this.threshold = threshold;
            this.color = color;
            this.messageCore = messageCore;
        }

        private String formatMessage(int actualValue) {
            return "Violation of " + this.messageCore + " of " + this.threshold + ": " + actualValue;
        }

        private boolean isViolation(int value) {
            if (NumericMetricAnalyzerBase.this.aggregateMax()) {
                return value > this.threshold;
            }
            return value < this.threshold;
        }
    }
}

