/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.task;

import com.teamscale.index.task.Task;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.Nullable;

@Index(name="tasks", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK, EStorageOption.BACKUP})
public class TaskIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "tasks";
    private final ValueIndex<Task> delegate;

    public TaskIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setTask(int taskId, Task task) throws StorageException {
        CCSMAssert.isTrue((taskId >= 0 ? 1 : 0) != 0, (String)"Task ID must be non-negative");
        this.delegate.setValue(String.valueOf(taskId), (Object)task);
    }

    public List<Task> getAllTasks() throws StorageException {
        return this.delegate.getAllEntries().extractSecondList();
    }

    public @Nullable Task getTask(int taskId) throws StorageException {
        return (Task)this.delegate.getValue(String.valueOf(taskId));
    }
}

