/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.PartitionIndexUtils;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;

public class CachedPartitionsStoreFeature {
    private static final String PARTITION_KEY = "__PARTITIONS__";
    private final Set<String> cachedPartitions = Collections.synchronizedSet(new HashSet());
    private final ConvenientStore store;

    public CachedPartitionsStoreFeature(IStore store) {
        this.store = new ConvenientStore(store);
    }

    public List<String> getPartitions() throws StorageException {
        if (!this.cachedPartitions.isEmpty()) {
            return new ArrayList<String>(this.cachedPartitions);
        }
        List partitions = CollectionUtils.emptyIfNull((List)StorageUtils.deserializeStringList((byte[])this.store.getWithString(PARTITION_KEY)));
        this.cachedPartitions.addAll(partitions);
        return partitions;
    }

    public void addPartitions(Collection<String> partitions) throws StorageException {
        if (this.cachedPartitions.containsAll(partitions)) {
            return;
        }
        Set mergedPartitions = PartitionIndexUtils.addStoredPartitions((ConvenientStore)this.store, partitions, (String)PARTITION_KEY);
        this.cachedPartitions.addAll(mergedPartitions);
    }
}

