/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.usage.MethodUsageCountIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class AbapMethodMovementSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MethodUsageCountIndex usageCountIndex;
    @DeltaSource(value=MethodInfoIndex.class)
    private IndexDelta<UniformPath> keyDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MethodInfoIndex methodInfoIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private MethodInfoIndex previousMethodInfoIndex;

    public void execute() throws StorageException {
        if (this.keyDelta.isEmpty()) {
            return;
        }
        ArrayList<UniformPath> changedUniformPaths = new ArrayList<UniformPath>(CollectionUtils.unionSet((Collection)this.keyDelta.getAddedOrChangedKeys(), (Collection[])new Collection[]{this.keyDelta.getDeletedKeys()}));
        List<AssociatedMethodInfo> methodInfosForChangedUniformPaths = this.previousMethodInfoIndex.getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(changedUniformPaths);
        HashMap<String, String> oldToNewMethodLocations = new HashMap<String, String>();
        methodInfosForChangedUniformPaths.forEach(info -> oldToNewMethodLocations.put(info.getKey(), null));
        List<AssociatedMethodInfo> addedOrChangedMethodInfos = this.methodInfoIndex.getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo((List<UniformPath>)this.keyDelta.getAddedOrChangedKeys());
        for (AssociatedMethodInfo associatedMethodInfo : addedOrChangedMethodInfos) {
            String currentMethodLocation = associatedMethodInfo.getKey();
            if (this.getSchedulingCommit().equals((Object)associatedMethodInfo.getLastInfoUpdateCommit())) {
                String previousMethodLocation = (String)associatedMethodInfo.getPredecessorCommitsWithKeys().getSecond(0);
                oldToNewMethodLocations.put(previousMethodLocation, currentMethodLocation);
                continue;
            }
            oldToNewMethodLocations.remove(currentMethodLocation);
        }
        this.usageCountIndex.applyMethodLocationChanges(oldToNewMethodLocations);
    }
}

