/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap.structure;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;

public enum EProcessingBlockType {
    LISE,
    ATPF,
    ATSS,
    ATUC,
    ENPA,
    ESEL,
    FORM,
    FUNC,
    INIT,
    LDPR,
    METH,
    MODI,
    MODO,
    SSEL,
    TOPA,
    PROG,
    GETL,
    GET,
    TOPS;

    public static final EnumSet<EProcessingBlockType> COUNTED_TYPES;

    public static EProcessingBlockType fromShallowEntity(ShallowEntity entity) throws ConQATException {
        String subType;
        switch (subType = entity.getSubtype()) {
            case "form": {
                return FORM;
            }
            case "function": {
                return FUNC;
            }
            case "method declaration": 
            case "method implementation": {
                return METH;
            }
            case "module input": {
                return MODI;
            }
            case "module output": {
                return MODO;
            }
            case "get late": {
                return GETL;
            }
            case "top-of-page during line-selection": {
                return TOPS;
            }
            case "pf event": {
                return ATPF;
            }
        }
        subType = StringUtils.stripPrefix((String)subType.toUpperCase(), (String)"AT ");
        ETokenType tokenType = ETokenType.valueOf((String)subType.replace('-', '_'));
        EProcessingBlockType processingBlockType = EProcessingBlockType.fromTokenType(tokenType);
        if (processingBlockType != null) {
            return processingBlockType;
        }
        throw new ConQATException("unknown processing block type: " + entity.getSubtype());
    }

    private static EProcessingBlockType fromTokenType(ETokenType type) {
        switch (type) {
            case INITIALIZATION: {
                return INIT;
            }
            case REPORT: 
            case PROGRAM: 
            case START_OF_SELECTION: {
                return SSEL;
            }
            case END_OF_SELECTION: {
                return ESEL;
            }
            case TOP_OF_PAGE: {
                return TOPA;
            }
            case END_OF_PAGE: {
                return ENPA;
            }
            case LOAD_OF_PROGRAM: {
                return LDPR;
            }
            case SELECTION_SCREEN: {
                return ATSS;
            }
            case LINE_SELECTION: {
                return LISE;
            }
            case USER_COMMAND: {
                return ATUC;
            }
            case GET: {
                return GET;
            }
        }
        return null;
    }

    static {
        COUNTED_TYPES = EnumSet.of(LISE, new EProcessingBlockType[]{ATUC, ESEL, INIT, LDPR, SSEL, TOPA, TOPS});
    }
}

