/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.testgap.ExecutedMethodIndex;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodIssueIndex;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAbapBwAggregator;
import com.teamscale.index.testgap.assessment.TgaAssessor;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.TestInfoFilter;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.ITgaCoverageSourceParameter;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.date.DateTimeUtils;

public abstract class TgaRequestBase
implements ITgaRequest {
    private static final TgaAbapBwAggregator BW_AGGREGATOR = new TgaAbapBwAggregator();
    private final ITgaCoverageSourceParameter coverageSourceOptions;
    protected final ETgaAssessmentType assessmentType;
    protected final long baseline;
    protected final CommitDescriptor endCommit;
    protected final IndexLayer indexLayer;
    protected final IProjectId projectId;
    protected final TestInfoFilter testInfoFilter;

    protected TgaRequestBase(ITgaCoverageSourceParameter coverageSourceOptions, ETgaAssessmentType assessmentType, long baseline, CommitDescriptor endCommit, IProjectId projectId, IndexLayer indexLayer) {
        this.coverageSourceOptions = coverageSourceOptions;
        this.assessmentType = assessmentType;
        this.baseline = baseline;
        this.endCommit = endCommit;
        this.projectId = projectId;
        this.indexLayer = indexLayer;
        this.testInfoFilter = TestInfoFilter.getTestInfoFilter(assessmentType, baseline);
    }

    @Override
    public long getBaselineTimestamp() {
        return this.baseline;
    }

    @Override
    public CommitDescriptor getIndexAccessCommit() {
        return this.endCommit;
    }

    @Override
    public TgaAssessor createAssessor() {
        return new TgaAssessor(this.getBaselineTimestamp(), this.getTgaAssessmentType());
    }

    protected abstract ITgaDataRetriever createDataRetriever(TgaDataRetrieverIndexes var1, CrossAnnotator var2, CodeScopeAware<Boolean> var3) throws StorageException;

    @Override
    public UnassessedTestGapData fetchUnassessedData(MethodInfoFilter methodInfoFilter) throws StorageException {
        ITgaDataRetriever retriever = this.createDataRetriever();
        UnassessedTestGapData unaggregatedData = retriever.fetchData(methodInfoFilter);
        return BW_AGGREGATOR.aggregateBwObjects(unaggregatedData);
    }

    @Override
    public AssessedTgaData fetchAndAssessData(MethodInfoFilter methodInfoFilter) throws StorageException {
        return this.createAssessor().assess(this.fetchUnassessedData(methodInfoFilter));
    }

    private ITgaDataRetriever createDataRetriever() throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem(this.projectId);
        HistoryAccessOption readAccess = this.createReadAccess();
        MethodInfoIndex methodInfoIndex = (MethodInfoIndex)projectStorageSystem.openProjectIndex(MethodInfoIndex.class, readAccess);
        MethodLastTestedIndex methodLastTestedIndex = (MethodLastTestedIndex)projectStorageSystem.openProjectIndex(MethodLastTestedIndex.class, readAccess);
        MethodIssueIndex methodIssueIndex = (MethodIssueIndex)projectStorageSystem.openProjectIndex(MethodIssueIndex.class, readAccess);
        ContainerIndex containerIndex = (ContainerIndex)projectStorageSystem.openProjectIndex(ContainerIndex.class, "dir", readAccess);
        MetricsToArchitectureMetricsMappingIndex architectureMappingIndex = (MetricsToArchitectureMetricsMappingIndex)projectStorageSystem.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, readAccess);
        CrossAnnotator crossAnnotator = this.createCrossAnnotator();
        ExtendedResourceTypeIndex extendedResourceTypeIndex = (ExtendedResourceTypeIndex)projectStorageSystem.openProjectIndex(ExtendedResourceTypeIndex.class, readAccess);
        CodeScopesMappingIndex codeScopesMappingIndex = (CodeScopesMappingIndex)projectStorageSystem.openProjectIndex(CodeScopesMappingIndex.class, readAccess);
        return this.createDataRetriever(new TgaDataRetrieverIndexes(methodIssueIndex, methodInfoIndex, methodLastTestedIndex, extendedResourceTypeIndex, architectureMappingIndex, containerIndex, codeScopesMappingIndex), crossAnnotator, TgaRequestUtils.getTgaEnablementPerCodeScope((ProjectStorageSystem)projectStorageSystem, this.indexLayer.openGlobalStorageSystem()));
    }

    private HistoryAccessOption createReadAccess() {
        CommitDescriptor commit = this.getIndexAccessCommit();
        return HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp());
    }

    private CrossAnnotator createCrossAnnotator() throws StorageException {
        ProjectIndex projectIndex = this.indexLayer.openProjectIndex();
        Set<PublicProjectId> crossAnnotationProjects = this.coverageSourceOptions.getCrossAnnotationProjects(projectIndex);
        List crossAnnotationIndexes = TgaRequestUtils.getCrossAnnotationIndexes(crossAnnotationProjects, ExecutedMethodIndex.class, this.indexLayer).extractSecondList();
        return this.createCrossAnnotator(crossAnnotationIndexes, (ProjectStorageSystem)this.indexLayer.openProjectStorageSystem(this.projectId));
    }

    protected CrossAnnotator createCrossAnnotator(List<ExecutedMethodIndex> crossAnnotationIndexes, ProjectStorageSystem projectStorageSystem) {
        return CrossAnnotator.createForNonIssueRequest(crossAnnotationIndexes, projectStorageSystem);
    }

    @Override
    public ETgaAssessmentType getTgaAssessmentType() {
        return this.assessmentType;
    }

    @Override
    public List<String> getPartitions() throws StorageException {
        MethodLastTestedIndex methodLastTestedIndex = (MethodLastTestedIndex)this.indexLayer.openProjectIndex(this.projectId, MethodLastTestedIndex.class, this.createReadAccess());
        Set<String> partitionsFromMethodLastTestedIndex = methodLastTestedIndex.getPartitionsUpdatedAfter(this.getBaselineTimestamp());
        return this.coverageSourceOptions.getPartitions(partitionsFromMethodLastTestedIndex);
    }

    @Override
    public Set<PublicProjectId> getCrossAnnotationProjects() throws StorageException {
        ProjectIndex projectIndex = this.indexLayer.openProjectIndex();
        return this.coverageSourceOptions.getCrossAnnotationProjects(projectIndex);
    }

    protected static String getDefaultBranchName(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return ((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
    }

    protected abstract String getTgaRequestPrefix();

    public String toString() {
        return this.getTgaRequestPrefix() + " between " + DateTimeUtils.getUiFormattedDateString((long)this.baseline) + " and " + this.endCommitToString() + " on branch '" + this.endCommit.getBranchName() + "'.\n" + this.coverageSourceOptions.toString();
    }

    private String endCommitToString() {
        if (this.endCommit.isHeadCommit()) {
            return "now";
        }
        return DateTimeUtils.getUiFormattedDateString((long)this.endCommit.getTimestamp());
    }
}

