/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.testimpact.SelectedTest;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jpountz.xxhash.StreamingXXHash64;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.StorageIterator;
import org.conqat.engine.persistence.store.StorageIterators;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Index(name="prioritized-test-lists", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK})
public class PrioritizedTestListIndex
implements IProjectIndex {
    private final ValueIndex<ArrayList<SelectedTest>> delegate;

    public PrioritizedTestListIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public List<SelectedTest> getTestList(String listId) throws StorageException {
        @Nullable List list = (List)this.delegate.getValue(listId);
        if (list == null) {
            return new ArrayList<SelectedTest>();
        }
        return list;
    }

    private ArrayList<SelectedTest> convert(List<PrioritizableTest> tests) {
        return new ArrayList<SelectedTest>(CollectionUtils.map(tests, test -> new SelectedTest(test.getUniformPathString(), test.getPartition(), test.getDurationInMs(0L), test.getRank(), 0L, test.getNumberOfAdditionallyCoveredMethods())));
    }

    public void setTestList(String listId, List<PrioritizableTest> tests) throws StorageException {
        this.delegate.setValue(listId, this.convert(tests));
    }

    private Map<Integer, SelectedTest> getRankMappedTests(String listId) throws StorageException {
        HashMap<Integer, SelectedTest> result = new HashMap<Integer, SelectedTest>();
        @Nullable List list = (List)this.delegate.getValue(listId);
        if (list != null) {
            list.forEach(test -> result.put(test.rank(), (SelectedTest)test));
        }
        return result;
    }

    public TestListDeltaSummary deleteTestsWithRanking(String listId, Set<Integer> testRankings) throws StorageException {
        Map<Integer, SelectedTest> map = this.getRankMappedTests(listId);
        for (int rank : testRankings) {
            SelectedTest test = map.get(rank);
            CCSMAssert.isTrue((test.rank() == rank ? 1 : 0) != 0, (String)"Assuming ranks with an corresponding list index.");
            map.remove(rank);
        }
        long totalDurationMs = 0L;
        ArrayList<SelectedTest> newTestList = new ArrayList<SelectedTest>(map.values().size());
        StreamingXXHash64 testListHash = XXHashUtils.streamingHash64();
        for (SelectedTest test : map.values()) {
            PrioritizedTestListIndex.updateHashWithTestAtPosition(testListHash, test);
            newTestList.add(SelectedTest.withSuiteDuration(test, totalDurationMs += test.durationInMs()));
        }
        this.delegate.setValue(listId, newTestList);
        return new TestListDeltaSummary(newTestList.size(), 0, testRankings.size(), totalDurationMs, XXHashUtils.asReadableString((StreamingXXHash64)testListHash));
    }

    public void clearRankingResult(String listId) throws StorageException {
        this.delegate.removeValue(listId);
    }

    public TestListDeltaSummary appendToList(String prioritizedTestListId, Collection<SelectedTest> toAppend) throws StorageException {
        int suiteTestCount = 0;
        long suiteDurationMs = 0L;
        int addedTests = 0;
        StreamingXXHash64 testListHash = XXHashUtils.streamingHash64();
        LinkedHashSet<SelectedTest> remaining = new LinkedHashSet<SelectedTest>(toAppend);
        ArrayList<SelectedTest> containedTests = new ArrayList<SelectedTest>(this.getTestList(prioritizedTestListId));
        int maxTestRankingNumber = 0;
        for (SelectedTest test : containedTests) {
            remaining.remove(test);
            maxTestRankingNumber = Math.max(maxTestRankingNumber, test.rank());
            ++suiteTestCount;
            suiteDurationMs += test.durationInMs();
            PrioritizedTestListIndex.updateHashWithTestAtPosition(testListHash, test);
        }
        for (SelectedTest test : remaining) {
            ++addedTests;
            ++suiteTestCount;
            containedTests.add(new SelectedTest(test.uniformPath(), test.partition(), test.durationInMs(), ++maxTestRankingNumber, suiteDurationMs += test.durationInMs(), 0));
            PrioritizedTestListIndex.updateHashWithTestAtPosition(testListHash, test);
        }
        this.delegate.setValue(prioritizedTestListId, containedTests);
        return new TestListDeltaSummary(suiteTestCount, addedTests, 0, suiteDurationMs, XXHashUtils.asReadableString((StreamingXXHash64)testListHash));
    }

    private static void updateHashWithTestAtPosition(StreamingXXHash64 testListHash, SelectedTest test) {
        XXHashUtils.updateHash((StreamingXXHash64)testListHash, (String)test.uniformPath());
        XXHashUtils.updateHash((StreamingXXHash64)testListHash, (String)StringUtils.emptyIfNull((String)test.partition()));
        XXHashUtils.updateHash((StreamingXXHash64)testListHash, (String)Integer.toString(test.rank()));
    }

    public StorageIterator<SelectedTest, StorageException> listIterator(String listId) throws StorageException {
        return StorageIterators.asStorageIterator(this.getTestList(listId));
    }

    public record TestListDeltaSummary(int totalTests, int addedTests, int removedTests, long totalDurationMs, String testListHash) {
    }
}

