/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Set;

public class TiaPartitionsQueryParams {
    @QueryParam(value="partitions")
    @Parameter(description="This parameter may be given multiple times. Specifies the test coverage partitions to consider.")
    @JsonProperty(value="partitions")
    private Set<String> partitions;
    @QueryParam(value="all-partitions")
    @Parameter(description="If this is true, all available test coverage partitions are considered.")
    @JsonProperty(value="allPartitions")
    private boolean allPartitions;

    public TiaPartitionsQueryParams() {
    }

    public TiaPartitionsQueryParams(Set<String> partitions, boolean allPartitions) {
        this.partitions = partitions;
        this.allPartitions = allPartitions;
    }

    public Set<String> getPartitions() {
        return this.partitions;
    }

    public boolean isAllPartitions() {
        return this.allPartitions;
    }

    public TgaCoverageSourceQueryParameters toCoverageSourceQueryParameters(List<String> crossAnnotationProjectPatterns) {
        return new TgaCoverageSourceQueryParameters(crossAnnotationProjectPatterns, this.partitions.stream().toList(), this.allPartitions);
    }

    public void setAllPartitionsWhenPartitionsEmpty() {
        if (this.partitions.isEmpty()) {
            this.allPartitions = true;
        }
    }
}

