/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor.custom;

import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.issue_reference.SpecItemEntityExtractor;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.TestCaseExtractionUtils;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CustomTestCaseExtractionStrategy
implements ITestCaseExtractionStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String NAME_FIELD = "Name";
    private static final String SINGLE_LINE_BREAK = "(?<=[^\\s])\n(?=[^\\s])";
    private final Map<String, Pattern> testPatterns;

    public CustomTestCaseExtractionStrategy(PairList<String, String> testPatterns) {
        this.testPatterns = testPatterns.mapSecond(Pattern::compile).toMap();
        CCSMAssert.isTrue((this.testPatterns.isEmpty() || this.testPatterns.containsKey(NAME_FIELD) ? 1 : 0) != 0, (String)"Test identification patterns must at least contain a Name field mapping!");
    }

    @Override
    public PairList<String, TestImplementation> extractTestCases(TokenElementTransformContext context, TypeIndexCache typeIndex) {
        if (this.testPatterns.isEmpty()) {
            return new PairList();
        }
        return this.detectTestsInCode(context);
    }

    private PairList<String, TestImplementation> detectTestsInCode(TokenElementTransformContext context) {
        IdentityHashSet alreadyDetectedEntities = new IdentityHashSet();
        PairList result = new PairList();
        Pattern namePattern = this.testPatterns.get(NAME_FIELD);
        CustomTestCaseExtractionStrategy.forEachPatternMatch(context, namePattern, (arg_0, arg_1, arg_2) -> this.lambda$detectTestsInCode$0((Set)alreadyDetectedEntities, context, result, arg_0, arg_1, arg_2));
        return result;
    }

    private static void forEachPatternMatch(TokenElementTransformContext context, Pattern pattern, PatternMatchConsumer patternConsumer) {
        UnmodifiableList<ShallowEntity> entities = context.getShallowEntitiesWithPreprocessorTokens();
        String filteredText = context.getTokenElementInfo().getFilteredText();
        Matcher matcher = pattern.matcher(filteredText);
        while (matcher.find()) {
            String firstGroup = matcher.group(1);
            String uniformPath = context.getUniformPath();
            if (firstGroup.isBlank()) {
                LOGGER.warn("Discovered a test property in " + uniformPath + ", but its capture group one is empty! Complete match: " + matcher.group());
                return;
            }
            IToken token = TokenStreamUtils.findFirstTokenOverlappingWith(context.getTokens(), (int)matcher.start(1), (int)matcher.end(1));
            if (token == null) {
                LOGGER.warn("No token found for test property match " + matcher.group() + " in file " + uniformPath);
                continue;
            }
            ShallowEntity shallowEntity = CustomTestCaseExtractionStrategy.findMethodEntityForToken(entities, uniformPath, token);
            if (shallowEntity == null) {
                LOGGER.warn("No entity found for test property match " + matcher.group() + " in file " + uniformPath + " at line " + token.getLineNumber());
                continue;
            }
            patternConsumer.process(token, shallowEntity, firstGroup);
        }
    }

    private static ShallowEntity findMethodEntityForToken(List<ShallowEntity> entities, String uniformPath, IToken token) {
        ShallowEntity entityOfComment = SpecItemEntityExtractor.getSpecItemEntity(token, entities, uniformPath);
        if (entityOfComment == null || CustomTestCaseExtractionStrategy.isMethodOrMeta(entityOfComment)) {
            return entityOfComment;
        }
        return ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entityOfComment, CustomTestCaseExtractionStrategy::isMethodOrMeta).orElse(null);
    }

    private static boolean isMethodOrMeta(ShallowEntity parent) {
        return parent.getType() == EShallowEntityType.METHOD || parent.getType() == EShallowEntityType.META;
    }

    private static TestImplementation buildTestImplementation(String testName, TokenElementTransformContext context, ShallowEntity nonRawShallowEntity) {
        String implementationHash = TestCaseExtractionUtils.buildImplementationHash(nonRawShallowEntity);
        TextRegionLocation location = context.createLocationForNonRawShallowEntity(nonRawShallowEntity);
        TextRegionLocation codeLocationWithComment = TestCaseExtractionUtils.createCommentIncludingLocationForShallowEntity(context, nonRawShallowEntity, location, Function.identity());
        return new TestImplementation(testName, implementationHash, location, codeLocationWithComment);
    }

    private LinkedHashMap<String, String> extractFieldNames(TokenElementInfo tokenElementInfo, TextRegionLocation locationWithComment) {
        StringOffsetTransformer stringOffsetTransformer = new StringOffsetTransformer((List)tokenElementInfo.getFilterDeletions());
        String text = tokenElementInfo.getText();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.testPatterns.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(NAME_FIELD)).forEach(entry -> {
            Matcher matcher = ((Pattern)entry.getValue()).matcher(text);
            matcher.region(locationWithComment.getRawStartOffset(), locationWithComment.getRawEndOffset());
            if (matcher.find()) {
                if (stringOffsetTransformer.isFilteredOffset(matcher.start(1))) {
                    return;
                }
                String match = matcher.group(1);
                if (CustomTestCaseExtractionStrategy.isMatchOnCommentToken(tokenElementInfo, matcher.start(1), matcher.end(1))) {
                    match = LanguageProperties.of((ELanguage)tokenElementInfo.getLanguage()).getCommentContent(match);
                }
                String value = match.replaceAll(SINGLE_LINE_BREAK, " ").trim();
                result.put((String)entry.getKey(), value);
            }
        });
        return result;
    }

    private static boolean isMatchOnCommentToken(TokenElementInfo tokenElementInfo, int startOffset, int endOffset) {
        IToken token = TokenStreamUtils.findFirstTokenOverlappingWith(tokenElementInfo.getTokens(), (int)startOffset, (int)endOffset);
        return token != null && TokenUtils.isCommentToken((IToken)token);
    }

    private /* synthetic */ void lambda$detectTestsInCode$0(Set alreadyDetectedEntities, TokenElementTransformContext context, PairList result, IToken token, ShallowEntity shallowEntity, String testName) {
        if (alreadyDetectedEntities.contains(shallowEntity)) {
            LOGGER.warn("Discovered two test names for the same code entity in file " + context.getUniformPath() + " at line " + token.getLineNumber() + ". Ignoring " + testName + "!");
            return;
        }
        UniformPath path = TestCaseExtractionUtils.convertToTestImplementationUniformPath(context.getUniformPath(), testName);
        TestImplementation testImplementation = CustomTestCaseExtractionStrategy.buildTestImplementation(testName, context, shallowEntity);
        result.add((Object)path.toString(), (Object)testImplementation);
        alreadyDetectedEntities.add(shallowEntity);
        LinkedHashMap<String, String> fields = this.extractFieldNames(context.getTokenElementInfo(), testImplementation.getLocationWithComment());
        LinkedHashMap<String, String> properties = testImplementation.getProperties();
        fields.put(NAME_FIELD, testName);
        fields.forEach(properties::putIfAbsent);
    }

    private static interface PatternMatchConsumer {
        public void process(IToken var1, ShallowEntity var2, String var3);
    }
}

