/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.algorithm.EFindingIdentificationCriterion;
import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.algorithm.TrackedUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.io.ByteArrayUtils;

public class TrackedFindingMinHasher {
    private static final int SEED = 7919;
    private static final int SIGNATURE_SIZE = 200;
    private static final int HASH_CONTENT_SIZE = 30;
    private static final int[][] HASH_COEFFICIENTS = new int[200][2];

    public static byte[] hashEncode(TrackedElement element, TrackedFinding finding) {
        List<TrackedUnit> relevantUnits;
        if (finding.getLocation() instanceof TextRegionLocation) {
            Optional<Pair<Integer, Integer>> startAndEndIndex = EFindingIdentificationCriterion.getStartAndEndIndex((IndexFinding)finding, element);
            if (startAndEndIndex.isEmpty()) {
                return null;
            }
            relevantUnits = TrackedFindingMinHasher.selectUnits((Integer)startAndEndIndex.get().getFirst() - 30, (Integer)startAndEndIndex.get().getSecond() + 30, element.getUnits());
        } else {
            relevantUnits = element.getUnits();
        }
        return TrackedFindingMinHasher.calculateMinHash(relevantUnits);
    }

    public static double getSimilarity(byte[] hash1, byte[] hash2) {
        double similarity = 0.0;
        for (int i = 0; i < 200; ++i) {
            int offset = i * 4;
            if (!TrackedFindingMinHasher.isSingleHashValueEqual(hash1, hash2, offset)) continue;
            similarity += 1.0;
        }
        return similarity / 200.0;
    }

    private static boolean isSingleHashValueEqual(byte[] hash1, byte[] hash2, int offset) {
        return hash1[offset] == hash2[offset] && hash1[offset + 1] == hash2[offset + 1] && hash1[offset + 2] == hash2[offset + 2] && hash1[offset + 3] == hash2[offset + 3];
    }

    private static List<TrackedUnit> selectUnits(int inclusiveStart, int exclusiveEnd, List<TrackedUnit> units) {
        if ((inclusiveStart = Math.max(0, inclusiveStart)) >= (exclusiveEnd = Math.min(exclusiveEnd, units.size()))) {
            return new ArrayList<TrackedUnit>();
        }
        return units.subList(inclusiveStart, exclusiveEnd);
    }

    static byte[] calculateMinHash(List<TrackedUnit> relevantUnits) {
        HashSet<Integer> unitHashCodeSet = new HashSet<Integer>();
        for (TrackedUnit relevantUnit : relevantUnits) {
            unitHashCodeSet.add(relevantUnit.hashCode());
        }
        ArrayList<Integer> unitHashCodeList = new ArrayList<Integer>(unitHashCodeSet);
        int[] signature = TrackedFindingMinHasher.calculateSignature(unitHashCodeList);
        byte[] result = new byte[800];
        for (int i = 0; i < 200; ++i) {
            ByteArrayUtils.putIntIntoByteArray((byte[])result, (int)(i * 4), (int)signature[i]);
        }
        return result;
    }

    private static int[] calculateSignature(List<Integer> unitHashCodes) {
        int[] signature = new int[200];
        for (int i = 0; i < 200; ++i) {
            signature[i] = Integer.MAX_VALUE;
        }
        for (int unitHashCode : unitHashCodes) {
            for (int i = 0; i < 200; ++i) {
                signature[i] = Math.min(signature[i], TrackedFindingMinHasher.hashSingleUnit(i, unitHashCode));
            }
        }
        return signature;
    }

    private static int hashSingleUnit(int hashIndex, int unit) {
        return unit * HASH_COEFFICIENTS[hashIndex][0] + HASH_COEFFICIENTS[hashIndex][1];
    }

    static {
        Random random = new Random(7919L);
        for (int i = 0; i < 200; ++i) {
            TrackedFindingMinHasher.HASH_COEFFICIENTS[i][0] = random.nextInt();
            TrackedFindingMinHasher.HASH_COEFFICIENTS[i][1] = random.nextInt();
        }
    }
}

