/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.user.User;
import com.teamscale.core.utils.TimestampedInteraction;
import com.teamscale.index.user.UserRecentInteractionIndex;
import java.util.List;
import java.util.OptionalLong;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="user-recent-commits", valueClasses={TimestampedInteraction.class}, options={EStorageOption.NO_ROLLBACK})
public class UserRecentlyCommittedCommitsIndex
implements IProjectIndex,
IChangeTrackingIndex {
    public static final String INDEX_NAME = "user-recent-commits";
    private final UserRecentInteractionIndex<CommitDescriptor> delegate;

    public UserRecentlyCommittedCommitsIndex(IStore store) {
        this.delegate = new UserRecentInteractionIndex(store);
    }

    public List<TimestampedInteraction<CommitDescriptor>> getRecentCommits(User user) throws StorageException {
        return this.delegate.getRecentRelatedItems(user);
    }

    public void registerCommit(String userName, CommitDescriptor commit) throws StorageException {
        this.delegate.registerItemInteraction(userName, (CommitDescriptor)new TimestampedInteraction(Long.valueOf(commit.getTimestamp()), (Comparable)commit));
    }

    public OptionalLong getLastChangeTimestamp() throws StorageException {
        return this.delegate.getLastChangeTimestamp();
    }
}

