/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

public abstract class LockableIndex<LOCKED_INDEX_ACCESS> {
    private static final String INDEX_LOCK = "lock";
    private final IStore store;

    protected LockableIndex(IStore store) {
        this.store = store;
    }

    public <E extends Exception> void runWithLock(LockedOperation<LOCKED_INDEX_ACCESS, E> operation) throws StorageException, E {
        Lock lock = this.store.obtainLock(INDEX_LOCK);
        lock.lock();
        try {
            operation.run(this.getIndexAccess(this.store));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> T computeWithLock(LockedComputation<T, LOCKED_INDEX_ACCESS, E> computation) throws StorageException, E {
        Lock lock = this.store.obtainLock(INDEX_LOCK);
        lock.lock();
        try {
            T t = computation.compute(this.getIndexAccess(this.store));
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract LOCKED_INDEX_ACCESS getIndexAccess(IStore var1);

    @FunctionalInterface
    public static interface LockedOperation<LOCKED_INDEX, E extends Exception> {
        public void run(LOCKED_INDEX var1) throws StorageException, E;
    }

    @FunctionalInterface
    public static interface LockedComputation<T, LOCKED_INDEX, E extends Exception> {
        public T compute(LOCKED_INDEX var1) throws StorageException, E;
    }
}

