/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IStorageKeyTranslatingIndex;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

public final class ScatteredCollectionIndex<T>
implements IStorageKeyTranslatingIndex,
IUtilityIndex {
    private final DelegatingPartitionStore sizeStore;
    private final DelegatingPartitionStore elementStore;
    private final ISerializer<T, byte[]> serializer;
    private final int batchSize;

    private ScatteredCollectionIndex(IStore store, ISerializer<T, byte[]> serializer, int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("%s (%d) must be at least 1".formatted("batchSize", batchSize));
        }
        this.sizeStore = new DelegatingPartitionStore(store, "s");
        this.elementStore = new DelegatingPartitionStore(store, "e");
        this.serializer = serializer;
        this.batchSize = batchSize;
    }

    public static <T extends Serializable> ScatteredCollectionIndex<T> forSerializable(IStore store, int batchSize) {
        return new ScatteredCollectionIndex(store, ISerializer.forSerializable(), batchSize);
    }

    public static <T> ScatteredCollectionIndex<T> of(IStore store, ISerializer<T, byte[]> serializer, int batchSize) {
        return new ScatteredCollectionIndex<T>(store, serializer, batchSize);
    }

    public void put(byte[] key, Collection<? extends T> elements) throws StorageException {
        int existingSize = this.getExistingSize(key).orElse(0);
        this.sizeStore.put(key, ByteArrayUtils.intToByteArray((int)elements.size()));
        int elementIndex = 0;
        for (Iterable<T> batch : ScatteredCollectionIndex.partition(elements, this.batchSize)) {
            PairList serializedBatch = new PairList();
            for (T element : batch) {
                serializedBatch.add((Object)ScatteredCollectionIndex.elementIndex(key, elementIndex++), (Object)this.serializer.serialize(element));
            }
            this.elementStore.put((PairList<byte[], byte[]>)serializedBatch);
        }
        this.elementStore.remove(IntStream.range(elements.size(), existingSize).mapToObj(i -> ScatteredCollectionIndex.elementIndex(key, i)).toList());
    }

    public Optional<List<T>> get(byte[] key) throws StorageException {
        Optional<Integer> existingSize = this.getExistingSize(key);
        if (existingSize.isEmpty()) {
            return Optional.empty();
        }
        int elementCount = existingSize.get();
        ArrayList result = new ArrayList(elementCount);
        int i = 0;
        while (i + this.batchSize <= elementCount) {
            this.loadElements(key, i, this.batchSize, result);
            i += this.batchSize;
        }
        this.loadElements(key, result.size(), elementCount % this.batchSize, result);
        return Optional.of(result);
    }

    private void loadElements(byte[] key, int offset, int count, List<T> into) throws StorageException {
        ArrayList<byte[]> keys = new ArrayList<byte[]>(count);
        for (int indexInBatch = 0; indexInBatch < count; ++indexInBatch) {
            keys.add(ScatteredCollectionIndex.elementIndex(key, offset + indexInBatch));
        }
        for (byte[] value : this.elementStore.get(keys)) {
            into.add(this.serializer.deserialize(value));
        }
    }

    public void addElement(byte[] key, T element) throws StorageException {
        this.addElements(key, Collections.singletonList(element));
    }

    public void addElements(byte[] key, Collection<T> elements) throws StorageException {
        int existingElementCount = this.getExistingSize(key).orElse(0);
        for (Iterable<T> batch : ScatteredCollectionIndex.partition(elements, this.batchSize)) {
            PairList serializedBatch = new PairList(this.batchSize);
            for (T element : batch) {
                serializedBatch.add((Object)ScatteredCollectionIndex.elementIndex(key, existingElementCount++), (Object)this.serializer.serialize(element));
            }
            this.elementStore.put((PairList<byte[], byte[]>)serializedBatch);
        }
        this.sizeStore.put(key, ByteArrayUtils.intToByteArray((int)existingElementCount));
    }

    public T getElement(byte[] key, int index) throws IndexOutOfBoundsException, NoSuchElementException, StorageException {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index);
        }
        int elementCount = this.getExistingSize(key).orElseThrow(() -> new NoSuchElementException("No such key"));
        if (index >= elementCount) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.serializer.deserialize(this.elementStore.get(ScatteredCollectionIndex.elementIndex(key, index)));
    }

    public List<byte[]> listKeys() throws StorageException {
        return StorageUtils.listKeys(this.sizeStore);
    }

    public void remove(byte[] key) throws StorageException {
        int existingSize = this.getExistingSize(key).orElse(0);
        this.elementStore.remove(IntStream.range(0, existingSize).mapToObj(index -> ScatteredCollectionIndex.elementIndex(key, index)).toList());
        this.sizeStore.remove(key);
    }

    public void clear() throws StorageException {
        StorageUtils.clearStore(this.sizeStore);
        StorageUtils.clearStore(this.elementStore);
    }

    private static byte[] elementIndex(byte[] key, int elementIndex) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{key, ByteArrayUtils.intToByteArray((int)elementIndex)});
    }

    private Optional<Integer> getExistingSize(byte[] key) throws StorageException {
        return Optional.ofNullable(this.sizeStore.get(key)).map(ByteArrayUtils::byteArrayToInt);
    }

    private static <E> Iterable<Iterable<E>> partition(Iterable<E> elements, int batchSize) {
        Objects.requireNonNull(elements, "elements");
        if (batchSize < 1) {
            throw new IllegalArgumentException(batchSize + " must be greater than 0");
        }
        return () -> new PartitionedIterator(elements.iterator(), batchSize);
    }

    @Override
    public Set<StorageKey> resolveToPublicKeys(Collection<StorageKey> keys) {
        HashSet<StorageKey> result = new HashSet<StorageKey>();
        for (StorageKey key : keys) {
            byte[] keyBytes = key.getKey();
            if (this.sizeStore.isFromThisPartition(keyBytes)) {
                result.add(new StorageKey(this.sizeStore.getOriginalKey(keyBytes)));
                continue;
            }
            if (this.elementStore.isFromThisPartition(keyBytes)) {
                byte[] baseKey = Arrays.copyOfRange(keyBytes, 0, keyBytes.length - 4);
                result.add(new StorageKey(this.elementStore.getOriginalKey(baseKey)));
                continue;
            }
            throw new IllegalArgumentException("The key '%s' is not associated with this index.".formatted(new Object[]{key}));
        }
        return result;
    }

    @Override
    public IStore getWrappedStore() {
        return this.sizeStore.getBaseStore();
    }

    private static class PartitionedIterator<E>
    implements Iterator<Iterable<E>> {
        private final Iterator<E> delegate;
        private final int partitionSize;

        public PartitionedIterator(Iterator<E> delegate, int batchSize) {
            this.delegate = delegate;
            this.partitionSize = batchSize;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Iterable<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return () -> new CountingIterator<E>(this.delegate, this.partitionSize);
        }
    }

    private static class CountingIterator<E>
    implements Iterator<E> {
        private final Iterator<E> delegate;
        private final int maximumElements;
        private int count;

        public CountingIterator(Iterator<E> delegate, int maximumElements) {
            this.delegate = delegate;
            this.maximumElements = maximumElements;
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext() && this.count < this.maximumElements;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            return this.delegate.next();
        }
    }
}

