/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.lexer;

import java.util.Objects;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;

public class QueryToken {
    private final String text;
    private final int position;
    private final EQueryTokenType type;

    public QueryToken(EQueryTokenType type, String text, long position) {
        this.type = type;
        this.text = text;
        this.position = (int)position;
    }

    public EQueryTokenType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public int getPosition() {
        return this.position;
    }

    public String toString() {
        return "(" + String.valueOf((Object)this.type) + ") \"" + this.text + "\" at position: " + this.position;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.position, this.type});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryToken)) {
            return false;
        }
        QueryToken other = (QueryToken)obj;
        return other.position == this.position && other.type == this.type && Objects.equals(this.text, other.text);
    }
}

