/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class AttributeOperand
implements IAttributeOperand {
    private final String attribute;

    public AttributeOperand(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public <T> Function<T, Object> getValueAccessor(ICompilationContext<T> context) throws QueryCompilationException {
        Function accessor = this.getSafeAttributeAccessor(context, this.attribute);
        Function<String, Object> converter = AttributeOperand.getConverterFromStringToObject(this.getType(context));
        return object -> converter.apply((String)accessor.apply(object));
    }

    @Override
    public <T> Predicate<T> getValueEqualsIgnoreCasePredicate(ICompilationContext<T> context, Object comparisonValue, boolean lenient) throws QueryCompilationException {
        return context.getAttributeEqualsIgnoreCasePredicate(this.attribute, comparisonValue.toString(), lenient);
    }

    private static Function<String, Object> getConverterFromStringToObject(EKeyedObjectType type) throws QueryCompilationException {
        switch (type) {
            case NUMBER: {
                return Long::parseLong;
            }
            case STRING: 
            case DATE: {
                return object -> object;
            }
            case STRING_LIST: {
                return object -> StringUtils.splitToList((String)object, (String)",");
            }
            case NUMBER_LIST: {
                return object -> CollectionUtils.map((Collection)StringUtils.splitToList((String)object, (String)","), Long::parseLong);
            }
        }
        throw new QueryCompilationException("Unknown type: " + String.valueOf((Object)type), type.name());
    }

    @Override
    public <T> EKeyedObjectType getType(ICompilationContext<T> context) throws QueryCompilationException {
        return context.getAttributeType(this.attribute);
    }

    private <T> Function<T, String> getSafeAttributeAccessor(ICompilationContext<T> context, String attribute) throws QueryCompilationException {
        Function<T, String> attributeAccessor = context.getAttributeAccessor(attribute);
        EKeyedObjectType type = this.getType(context);
        switch (type) {
            case NUMBER: {
                return attributeAccessor.andThen(value -> Objects.requireNonNullElse(value, "0"));
            }
            case STRING: 
            case DATE: 
            case STRING_LIST: {
                return attributeAccessor.andThen(StringUtils::emptyIfNull);
            }
        }
        throw new QueryCompilationException("Unknown type: " + String.valueOf((Object)type), type.name());
    }

    public String toString() {
        return this.attribute;
    }
}

