/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.function.BiPredicate;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.BasicQueryBase;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.StaticOperand;

public class ComparisonQuery
extends BasicQueryBase {
    private final boolean greater;
    private final boolean includeEquals;

    public ComparisonQuery(IAttributeOperand attribute, StaticOperand value, boolean includeEquals, boolean greater) {
        super(attribute, value);
        this.greater = greater;
        this.includeEquals = includeEquals;
    }

    @Override
    protected String getReadableOperator() {
        Object operator = "<";
        if (this.greater) {
            operator = ">";
        }
        if (this.includeEquals) {
            operator = (String)operator + "=";
        }
        return operator;
    }

    @Override
    protected BiPredicate<Object, Object> getComparator(EKeyedObjectType type) throws QueryCompilationException {
        switch (type) {
            case NUMBER: {
                return (left, right) -> this.compare((Long)left, (Long)right);
            }
            case STRING: 
            case DATE: {
                return (left, right) -> this.compare((String)left, (String)right);
            }
        }
        throw new QueryCompilationException("Unknown type: " + String.valueOf((Object)type), type.name());
    }

    private <T extends Comparable<T>> boolean compare(T left, T right) {
        int result = left.compareTo(right);
        if (result == 0) {
            return this.includeEquals;
        }
        if (this.greater) {
            return result > 0;
        }
        return result < 0;
    }
}

