/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.mem;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.ISnapshotBackupCapability;
import org.conqat.engine.persistence.store.capability.IStorageInfoCapability;
import org.conqat.engine.persistence.store.capability.IStorageSystemCapability;
import org.conqat.engine.persistence.store.capability.RemovalCostCapability;
import org.conqat.engine.persistence.store.mem.InMemoryStorageSystem;
import org.conqat.engine.persistence.store.util.StorageSystemIdManager;

public class InMemoryStorageSystemProvider
implements IStorageSystemProvider,
IStorageInfoCapability,
ISnapshotBackupCapability {
    private final Map<String, InMemoryStorageSystem> storageSystems = new HashMap<String, InMemoryStorageSystem>();

    @Override
    public synchronized InMemoryStorageSystem openStorageSystem(String storageSystemName) {
        InMemoryStorageSystem storageSystem = this.storageSystems.get(storageSystemName);
        if (storageSystem == null) {
            storageSystem = new InMemoryStorageSystem(StorageSystemIdManager.getInstance().getOrCreateId(storageSystemName));
            this.storageSystems.put(storageSystemName, storageSystem);
        }
        return storageSystem;
    }

    @Override
    public synchronized void removeStorageSystem(String storageSystemName) {
        StorageSystemIdManager.getInstance().removeStorageSystem(storageSystemName);
        this.storageSystems.remove(storageSystemName);
    }

    @Override
    public void close() {
    }

    @Override
    public <T extends IStorageSystemCapability> Optional<T> getCapability(Class<T> capability) {
        if (capability == RemovalCostCapability.class) {
            return Optional.of(new RemovalCostCapability(true, true));
        }
        if (capability == IStorageInfoCapability.class) {
            return Optional.of(this);
        }
        if (capability == ISnapshotBackupCapability.class) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public String getStorageInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("In-memory storage system\n===================\n\n");
        this.storageSystems.forEach((name, storageSystem) -> {
            builder.append((String)name);
            builder.append("\n----------------\n");
            builder.append(storageSystem.getUsageStatistics(false));
            builder.append("\n");
        });
        return builder.toString();
    }

    @Override
    public synchronized void createSnapshotBackup(ISnapshotBackupCapability.ISnapshotConsumer snapshotConsumer) throws StorageException, IOException {
        HashMap<String, InMemoryStorageSystem> snapshots = new HashMap<String, InMemoryStorageSystem>();
        for (Map.Entry<String, InMemoryStorageSystem> entry : this.storageSystems.entrySet()) {
            snapshots.put(entry.getKey(), new InMemoryStorageSystem(entry.getValue()));
        }
        for (Map.Entry<String, InMemoryStorageSystem> entry : snapshots.entrySet()) {
            entry.getValue().dumpSnapshotBackup(entry.getKey(), snapshotConsumer);
        }
    }
}

